      subroutine putbparm (ncid)
c
c=======================================================================
c                                                                    ===
c  This routine writes the biological parameters tp the output       ===
c  netCDF file.  This particular version does so for the             ===
c  McGillicuddy et al. model.                                        ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCID     Identifier for output netCDF file.   (integer)        ===
c     VARTYP   NetCDF code for real variables.      (integer)        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <cbiopnh.h>
#include <netcdf.inc>
#include <pe_netcdf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ncid
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Write light attenuation parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'atth2o1',rcode)
      call ncvpt1 (ncid,varid,1,atth2o1*m2cm,rcode)
c
      varid = ncvid (ncid,'attphy',rcode)
      call ncvpt1 (ncid,varid,1,attphy*m2cm,rcode)
c
      varid = ncvid (ncid,'parfrac',rcode)
      call ncvpt1 (ncid,varid,1,parfrac,rcode)
c
c-----------------------------------------------------------------------
c  Write photosynthesis parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'photorm',rcode)
      call ncvpt1 (ncid,varid,1,photorm,rcode)
c
      varid = ncvid (ncid,'photor0',rcode)
      call ncvpt1 (ncid,varid,1,photor0,rcode)
c
      varid = ncvid (ncid,'photoinh',rcode)
      call ncvpt1 (ncid,varid,1,photoinh,rcode)
c
c-----------------------------------------------------------------------
c  Write nutrient uptake parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'hsno3',rcode)
      call ncvpt1 (ncid,varid,1,hsno3,rcode)
c
      varid = ncvid (ncid,'hsnh4',rcode)
      call ncvpt1 (ncid,varid,1,hsnh4,rcode)
c
      varid = ncvid (ncid,'no3inh',rcode)
      call ncvpt1 (ncid,varid,1,no3inh,rcode)
c
c-----------------------------------------------------------------------
c  Write zooplankton grazing parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'grazrm',rcode)
      call ncvpt1 (ncid,varid,1,grazrm,rcode)
c
      varid = ncvid (ncid,'civlev',rcode)
      call ncvpt1 (ncid,varid,1,civlev,rcode)
c
      varid = ncvid (ncid,'zooexc1',rcode)
      call ncvpt1 (ncid,varid,1,zooexc1,rcode)
c
c-----------------------------------------------------------------------
c  Write zooplankton loss rate parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'zoolr1',rcode)
      call ncvpt1 (ncid,varid,1,zoolr1,rcode)
c
      varid = ncvid (ncid,'zoolr2',rcode)
      call ncvpt1 (ncid,varid,1,zoolr2,rcode)
c
      varid = ncvid (ncid,'zooexp1',rcode)
      call ncvpt1 (ncid,varid,1,zooexp1,rcode)
c
      varid = ncvid (ncid,'zooexp2',rcode)
      call ncvpt1 (ncid,varid,1,zooexp2,rcode)
c
c-----------------------------------------------------------------------
c  Write sinking rate parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'sinkphy',rcode)
      call ncvpt1 (ncid,varid,1,sinkphy*cm2m,rcode)
c
      varid = ncvid (ncid,'sinkfac',rcode)
      call ncvpt1 (ncid,varid,1,sinkfac*cm2m,rcode)
c
c-----------------------------------------------------------------------
c  Write surface boundary layer parameter.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'sbldep',rcode)
      call ncvpt1 (ncid,varid,1,sbldep*cm2m,rcode)
c
c-----------------------------------------------------------------------
c  Write positive insurance parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'biopos',rcode)
      call ncvpt1 (ncid,varid,1,biopos,rcode)
c
#if defined codunlim | defined codlim
c-----------------------------------------------------------------------
c  Write cod behavior parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'cdzmin',rcode)
      call ncvpt1 (ncid,varid,1,cdzmin*cm2m,rcode)
c
      varid = ncvid (ncid,'cdzmax',rcode)
      call ncvpt1 (ncid,varid,1,cdzmax*cm2m,rcode)
c
      varid = ncvid (ncid,'cdkz',rcode)
      call ncvpt1 (ncid,varid,1,cdkz,rcode)
c
      varid = ncvid (ncid,'cdkp',rcode)
      call ncvpt1 (ncid,varid,1,cdkp,rcode)
c
      varid = ncvid (ncid,'cdtmin',rcode)
      call ncvpt1 (ncid,varid,1,cdtmin,rcode)
c
      varid = ncvid (ncid,'cdtmax',rcode)
      call ncvpt1 (ncid,varid,1,cdtmax,rcode)
c
      varid = ncvid (ncid,'cdkt',rcode)
      call ncvpt1 (ncid,varid,1,cdkt,rcode)
#  ifdef codlim
c
      varid = ncvid (ncid,'cdspd',rcode)
      call ncvpt1 (ncid,varid,1,cdspd,rcode)
#  endif
c
      varid = ncvid (ncid,'cdwmax',rcode)
      call ncvpt1 (ncid,varid,1,cdwmax,rcode)
c
#endif
      return
      end
