      subroutine rem_llist (no_list,ptrs,bgn,emt,curr,trail)
c
c=======================================================================
c                                                                    ===
c  This routine removes the specified element from a linked list by  ===
c  modifying the associated pointer list.                            ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     no_list...Number of elements in list structure. (integer)      ===
c     ptrs......List pointers.                        (integer array)===
c     bgn.......List beginning pointer.               (integer)      ===
c     emt.......Empty list beginning pointer.         (integer)      ===
c     curr......Current element to remove.            (integer)      ===
c     trail.....Preceeding element in list.           (integer)      ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     ptrs......List pointers.                        (integer array)===
c     bgn.......List beginning pointer.               (integer)      ===
c     emt.......Empty list beginning pointer.         (integer)      ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
      integer bgn,curr,emt,no_list,trail
      integer ptrs(no_list)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Either reconnect list around current element or set new list start.
c-----------------------------------------------------------------------
c
      if (trail.ne.0) then
         ptrs(trail) = ptrs(curr)
       else
         bgn = ptrs(curr)
      end if
c
c-----------------------------------------------------------------------
c  Connect current element as top of empty list.
c-----------------------------------------------------------------------
c
      ptrs(curr) = emt
      emt        = curr
c
c-----------------------------------------------------------------------
c  Reset current pointer.
c-----------------------------------------------------------------------
c
      if (trail.ne.0) then
         curr = ptrs(trail)
       else
         curr = bgn
      end if
c
      return
      end
