      subroutine reset_t_thickness
c
c=======================================================================
c                                                                    ===
c  This routine returns the depth at each grid point along a slab    ===
c  of constant J in the hybrid coordinate system.                    ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     In common blocks listed below.                                 ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     In common blocks:                                              ===
c                                                                    ===
c     Calls:  none                                                   ===
c                                                                    ===
c     Common Blocks: (only relevant variables listed)                ===
c                                                                    ===
c     /VERTICAL/                                                     ===
c                                                                    ===
c     HVZ       the depths at uv  3D grid points                     ===
c               (output; real array)                                 ===
c     HTZ       the depths at tracer  3D grid points                 ===
c               (output; real array)                                 ===
c                                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <vertical.h>
#include <vertslabs.h>
#include <tidesp.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,k
      FLOAT
     *      sumt
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      do 40 j=1,jmt
         do 30 i=1,imt
            sumt=c0
            do 10 k=1,km
               sumt=sumt+htz(i,k,j)
 10         continue
            tstretch(i,j)=(sumt+srftd(i,j))/sumt
 30      continue
 40   continue
      do 60 j=1,jmt
         do 50 i=1,imt
            ustretch(i,j)=c1
 50      continue
 60   continue
      do 80 j=1,jmt-1
         do 70 i=1,imt-1
            ustretch(i,j)=p25*(tstretch(i,j)+tstretch(i+1,j)+
     $           tstretch(i,j+1)+tstretch(i+1,j+1))
 70      continue
 80   continue

      return
      end


