      function rseterr (errobs,errfcst,corr,weight)
c
c=======================================================================
c                                                                    ===
c  This function resets the observation error so that the            ===
c  assimilation coefficient will be degraded by a weighting factor.  ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     ERROBS    Original observation error.                   (real) ===
c     ERRFCST   Forecast error.                               (real) ===
c     CORR      Correlation between observation & forecast.   (real) ===
c     WEIGHT    Degredation weight.                           (real) ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     RSETERR   New observation error.                        (real) ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      FLOAT
     &      corr,errfcst,errobs,weight
#ifndef simpramp
     &     ,a,crd,crgmen,d,fac
#endif
      FLOAT
     &      rseterr
c
c=======================================================================
c  Begin excutable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Handle the simple cases first.
c-----------------------------------------------------------------------
#ifndef simpramp
c
c  Supplied combination of errors and correlation will produce a zero
c  assimilation coefficient.  Any weighting is redundant.
c
      if ((corr*corr*errobs) .eq. errfcst) then
         rseterr = errobs
         return
      end if
c
c  Singular case, just set error to a large value.
c
      if ((corr .eq. c0) .and. (weight .eq. c0)) then
         rseterr = c1e6
         return
      end if
c
c  Zero correlation, formula is simpler.
c
      if (corr .eq. c0) then
         rseterr = (errobs + (c1-weight)*errfcst) / weight
         return
      end if
c
c  Requesting zero assimilation weight.
c
      if (weight .eq. c0) then
         rseterr = errfcst / (corr*corr)
         return
      end if
#else
c
c  Singular case, just set error to a large value.
c
      if (weight .eq. c0) then
         rseterr = c1e6
         return
      end if
#endif
c
c-----------------------------------------------------------------------
c  Solve the general case.
c-----------------------------------------------------------------------
#ifndef simpramp
c
      crgmen = corr * sqrt(errobs*errfcst)
c
      a   = weight*(errfcst-crgmen)
      d   = errobs + (c1-c2*weight)*errfcst - c2*(c1-weight)*crgmen
      crd = corr*d 
c
      fac = (sqrt(crd*crd + c4*a*(d+a)) - crd) / (c2*a)
c
      rseterr = errfcst*fac*fac
#else
c
      rseterr = errobs / weight
#endif
c
      return
      end
