      subroutine scalvcln (vin,vout)
c
c=======================================================================
c                                                                    ===
c  This routine multiplies the supplied baroclinic velocity          ===
c  component by the local box thickness.  Used in nesting to         ===
c  ensure baroclinicity of passed velocities.                        ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     VIN   Baroclinic velocity component to scale.   (real array)   ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
#ifdef gridold
c  /VERTSLABS/                                                       ===
c                                                                    ===
c     DZVQZ   Vertical box thickness.   (real array)                 ===
#else
c  /VERTICAL/                                                        ===
c                                                                    ===
c     DZV   Thicknesses of UV vertical boxes.       (real array; cm) ===
#endif
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     VOUT   Scaled baroclinic velocity component.    (real array)   ===
c                                                                    ===
c  Calls:  SETVERT                                                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#ifdef gridold
# include <vertslabs.h>
#else
# include <vertical.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local and equivalence data.
c-----------------------------------------------------------------------
c
      integer i,j,k
      FLOAT
     *      vin(imt,jmt,km),vout(imt,jmt,km)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 10 j = 1, jmt
#ifdef gridold
         call setvert(j)
#endif
         do 10 k = 1, km
         do 10 i = 1, imt
#ifdef gridold
            vout(i,j,k) = vin(i,j,k)*dzvqz(i,k,0)
#else
            vout(i,j,k) = vin(i,j,k)*dzv(i,j,k)
#endif
  10  continue
c
      return
      end
