      subroutine set_brlx
c
c=======================================================================
c                                                                    ===
c     This routine sets the coefficients for the boundary relaxation ===
c     terms.                                                         ===
c                                                                    ===
c     Calls:  none                                                   ===
c                                                                    ===
c     ------                                                         ===
c     Input:                                                         ===
c     ------                                                         ===
c                                                                    ===
c     Common Blocks:                                                 ===
c                                                                    ===
c     /BNDYRLX/                                                      ===
c                                                                    ===
#ifdef bndy_rlx
c     DVBRLX    V-grid Spatial e-folding scale for bndy relaxation.  ===
c     TVBRLX    V-grid Temporal e-folding scale for bndy relaxation. ===
c     DTBRLX    T-grid Spatial e-folding scale for bndy relaxation.  ===
c     TTBRLX    T-grid Temporal e-folding scale for bndy relaxation. ===
#endif
#ifdef cstfrc
c     DCSFRC    Spatial e-folding scale for coastal friction.        ===
c     TCSFRC    Temporal e-folding scale for coastal friction.       ===
#endif
#ifdef botfrc
c     DBTFRC    Spatial e-folding scale for bottom friction.         ===
c     TBTFRC    Temporal e-folding scale for bottom friction.        ===
#endif
c                                                                    ===
#ifdef coast
c     /FULLWD/                                                       ===
c                                                                    ===
c     LANDT     land/sea mask at the tracer points                   ===
c     LANDV     land/sea mask at the velocity points                 ===
c                                                                    ===
#endif
c     -------                                                        ===
c     Output:                                                        ===
c     -------                                                        ===
c                                                                    ===
c     Common Blocks:                                                 ===
c                                                                    ===
c     /BNDYRLX/                                                      ===
c                                                                    ===
#ifdef bndy_rlx
c     TFACBRLX  Boundary relaxation cofficient at tracer points.     ===
c     VFACBRLX  Boundary relaxation cofficient at velocity points.   ===
#endif
#ifdef cstfrc
c     FACCSFRC  Coastal friction cofficients.                        ===
#endif
#ifdef botfrc
c     FACBTFRC  Bottom friction cofficients.                         ===
#endif
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c     Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <bndyrlx.h>
#ifdef coast
#  include <fullwd.h>
#endif
c
c-----------------------------------------------------------------------
c     Define local data.
c-----------------------------------------------------------------------
c
      integer i
#if defined bndy_rlx | defined cstfrc
     *        ,j
#endif
#if defined coast & (defined bndy_rlx | defined cstfrc)
     *        ,ii,jj
      FLOAT
     *      dist
#  ifdef cstfrc
     *      ,spdist
#  endif
#endif
c
c=======================================================================
c     Begin executable code.
c=======================================================================
c
#ifdef bndy_rlx
c-----------------------------------------------------------------------
c     Define boundary relaxation coefficients at velocity points.
c-----------------------------------------------------------------------
c
      do 30 j = 1, jmt
      do 30 i = 1, imt
c
        if ((dvbrlx.gt.c0).and.(tvbrlx.gt.c0)) then

c
c         -- Find distance to nearest boundary/coastline.
c
          vfacbrlx(i,j) = FLoaT( min( i-2, imtm2-i, j-2, jmtm2-j ) )
          vfacbrlx(i,j) = max( vfacbrlx(i,j), c0 )
#  ifdef coast
          jj = 1
          do 20 while ((jj.le.jmt).and.(vfacbrlx(i,j).gt.c0))
            ii = 1
            do 10 while ((ii.le.imt).and.(vfacbrlx(i,j).gt.c0))
              if (landv(ii,jj).eq.0) then
                 dist = sqrt( (FLoaT(ii-i))**2 + (FLoaT(jj-j))**2 )
                 if (dist.lt.vfacbrlx(i,j)) vfacbrlx(i,j) = dist
              end if
              ii = ii + 1
 10         continue
            jj = jj + 1
 20       continue
#  endif
c
c         -- Compute boundary relaxation coefficient from minimum distance.
c
          vfacbrlx(i,j) = exp( cm1*(vfacbrlx(i,j)/dvbrlx)**2 ) / tvbrlx
c
         else
c
c           -- No boundary relaxation on velocity grid.
c
          vfacbrlx(i,j) = c0
c
        end if
c
 30   continue
c
c-----------------------------------------------------------------------
c     Define boundary relaxation coefficients at tracer points.
c-----------------------------------------------------------------------
c
      do 60 j = 1, jmt
      do 60 i = 1, imt
c
        if ((dtbrlx.gt.c0).and.(ttbrlx.gt.c0)) then
c
c         -- Find distance to nearest boundary/coastline.
c
          tfacbrlx(i,j) = FLoaT( min( i-2, imtm2-i, j-2, jmtm2-j ) )
          tfacbrlx(i,j) = max( tfacbrlx(i,j), c0 )
#  ifdef coast
          jj = 1
          do 50 while ((jj.le.jmt).and.(tfacbrlx(i,j).gt.c0))
            ii = 1
            do 40 while ((ii.le.imt).and.(tfacbrlx(i,j).gt.c0))
              if (landt(ii,jj).eq.0) then
                dist = sqrt( (FLoaT(ii-i))**2 + (FLoaT(jj-j))**2 )
                if (dist.lt.tfacbrlx(i,j)) tfacbrlx(i,j) = dist
              end if
              ii = ii + 1
 40         continue
            jj = jj + 1
 50       continue
#  endif
c
c         -- Compute boundary relaxation coefficient from minimum distance.
c
          tfacbrlx(i,j) = exp( cm1*(tfacbrlx(i,j)/dtbrlx)**2 ) /ttbrlx
c
         else
c
c         -- No boundary relaxation on tracer grid.
c
          tfacbrlx(i,j) = c0
c
        end if
c
 60   continue
c
#endif
#ifdef cstfrc
c-----------------------------------------------------------------------
c     Define coastal friction coefficients.
c-----------------------------------------------------------------------
c
#  ifdef coast
      spdist = c2*sqrt( FLoaT(imt*imt) + FLoaT(jmt*jmt) )
c
#  endif
      do 90 j = 1, jmt
      do 90 i = 1, imt
c
#  ifdef coast
        if ((dcsfrc.gt.c0).and.(tcsfrc.gt.c0)) then
c
c         -- Find distance to nearest coastline.
c
          faccsfrc(i,j) = spdist
          jj = 1
          do 80 while ((jj.le.jmt).and.(faccsfrc(i,j).gt.c0))
            ii = 1
            do 70 while ((ii.le.imt).and.(faccsfrc(i,j).gt.c0))
              if (landv(ii,jj).eq.0) then
                dist = sqrt( (FLoaT(ii-i))**2 + (FLoaT(jj-j))**2 )
                if (dist.lt.faccsfrc(i,j)) faccsfrc(i,j) = dist
              end if
              ii = ii + 1
 70         continue
            jj = jj + 1
 80       continue
c
c         -- Compute coastal friction coefficient from minimum distance.
c
          if (faccsfrc(i,j).lt.spdist) then
            faccsfrc(i,j) = exp(cm1*(faccsfrc(i,j)/dcsfrc)**2)/tcsfrc
           else
            faccsfrc(i,j) = c0
          end if
c
         else
#  endif
c
c         -- No coastal friction.
c
          faccsfrc(i,j) = c0
#  ifdef coast
c
        end if
#  endif
c
 90   continue
c
#endif
#ifdef botfrc
c-----------------------------------------------------------------------
c     Define bottom friction coefficients.
c-----------------------------------------------------------------------
c
      do 100 i = 1, km
c
        if ((dbtfrc.gt.c0).and.(tbtfrc.gt.c0)) then
          facbtfrc(i) = exp(cm1*(FLoaT(i-km)/dbtfrc)**2)/tbtfrc
         else
          facbtfrc(i) = c0
        end if
c
100   continue
c
#endif
      return
      end
