      subroutine set_edges (f,igrid)
c
c=======================================================================
c                                                                    ===
c  EDGES overwrite values for values next to coastal segments.       === 
c       INPUT/OUTPUT                                                 ===
c       F                                                            ===
c       igrid   t-grid or v-grid                                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <edges.h>
c-----------------------------------------------------------------------
c  Define local and equivalence data.
c-----------------------------------------------------------------------
c
      FLOAT
     *        f(imt*jmt)
      integer igrid
      integer l,ip,m,k
      FLOAT
     *        w  
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      if(igrid.eq.tgrid) then
         do 30 l=1,nedget
            ip=ipdxt(l)
            m=0
            do 10 k=1,8
               if(boxt(k,l).gt.0)m=m+1
 10         continue
            w=c1/FLoaT(m)
            f(ip)=c0
            do 20 k=1,m
               f(ip)=f(ip)+w*f(boxt(k,l))
 20         continue
 30      continue
      else
         do 60 l=1,nedgev
            ip=ipdxv(l)
            m=0
            do 40 k=1,8
               if(boxv(k,l).gt.0)m=m+1
 40         continue
            w=c1/FLoaT(m)
            f(ip)=c0
            do 50 k=1,m
               f(ip)=f(ip)+w*f(boxv(k,l))
 50         continue
 60      continue
      endif
      return
      end
