      subroutine set_pmask
c
c=======================================================================
c                                                                    ===
c  This routine sets a special mask for the transport streamfunction.===
c  Active values are set to zero.  Land points get the number of the ===
c  adjacent coastline.                                               ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /FULLWD/                                                          ===
c                                                                    ===
c     ICOAST     coast x-coordinate.                 (integer array) ===
c     JCOAST     coast y-coordinate.                 (integer array) ===
c     LANDT      land/sea mask at tracer points.     (integer array) ===
c     LENCOAST   number of points per coast.         (integer vector)===
c     NCSEG      number of coastal segments.         (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /FULLWD/                                                          ===
c                                                                    ===
c     LANDP      transport streamfn land/sea mask.   (integer array) ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <fullwd.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer d,dlow,i,im1,ip1,j,jm1,jp1,m,n
      integer mskwk(imt,jmt)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Extend land mask to include coastal nodes.
c-----------------------------------------------------------------------
c
      do 20 j = 1, jmt
         jm1 = max( (j-1), 1 )
         jp1 = min( (j+1), jmt)
         do 10 i = 1, imt
            im1 = max( (i-1), 1 )
            ip1 = min( (i+1), imt)
            mskwk(i,j) = landt(im1,jp1)*landt(i  ,jp1)*landt(ip1,jp1)*
     &                   landt(im1,j  )*landt(i  ,j  )*landt(ip1,j  )*
     &                   landt(im1,jm1)*landt(i  ,jm1)*landt(ip1,jm1)
  10     continue
  20  continue
c
c-----------------------------------------------------------------------
c Create mask indicating adjacent coasts.
c-----------------------------------------------------------------------
c
c
      do 40 j = 1, jmt
      do 40 i = 1, imt
c
         if (mskwk(i,j).eq.1) then
c
c           ---------------------
c           --- Active point. ---
c           ---------------------
c
            landp(i,j) = 0
c
           else
c
c           ------------------------------------------------
c           --- Inactive point, find adjacent coastline. ---
c           ------------------------------------------------
c
            dlow = 1 + imt*imt + jmt*jmt
            do 30 n = 1, ncseg
            do 30 m = 1, lencoast(n)
               d = (i-icoast(m,n))**2 + (j-jcoast(m,n))**2
               if (d.lt.dlow) then
                  dlow = d
                  landp(i,j) = n
               end if
  30        continue
c
         end if
c
  40  continue
c
      return
      end
