      subroutine setvert(j)
c
c=======================================================================
c                                                                    ===
c  This routine sets depths for tracers  and  velocity points and    ===
c  all the auxiliary arrays for vertical operations in the hybrid    ===
c  (topography-following) coordinate system at the Jth slab.         ===
c                                                                    ===
c  Calls:  GET_THICK,  DEPTHSLAB                                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <onedim.h>
#include <workspa.h>
#include <vertslabs.h>
#include <extra.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,jnew,jptr,k,newslab
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  When j=1, initialize rolling storage and pointers.
c
      if(j.eq.1) then
#if defined hpg4 | !defined shapiro
        jrnp1=2
        jrn=1
        jrs=0
        jrsm1=3
        call depthslab(1,tgrid,tdepth(1,1,jrs))
        call depthslab(1,tgrid,tdepth(1,1,jrn))
        call depthslab(2,tgrid,tdepth(1,1,jrnp1))
        call depthslab(1,vgrid,vdepth(1,1,jrs))
        call depthslab(1,vgrid,vdepth(1,1,jrn))
        call depthslab(1,vgrid,vdepth(1,1,jrnp1))
#else
        jrn=0
        jrs=1
        call depthslab(1,tgrid,tdepth(1,1,jrn))
        call depthslab(1,vgrid,vdepth(1,1,jrn))
#endif
      endif
c
c  Update pointers to rolling storage.
c
      jrs=mod(jrs+1,iord)
      jrn=mod(jrn+1,iord)
#if defined hpg4 | !defined shapiro
      jrsm1=mod(jrsm1+1,iord)
      jrnp1=mod(jrnp1+1,iord)
      newslab=jrnp1
      jnew=j+2
#else
      newslab=jrn
      jnew=j+1
#endif
c
c-----------------------------------------------------------------------
c  Set new tracer points depths and get current vertical spacing and
c  vertical thicknesses arrays.
c-----------------------------------------------------------------------
c
      jptr=min(jnew,jmt)
      call depthslab(jptr,tgrid,tdepth(1,1,newslab))
#ifdef gridold
      call get_thick(tdepth(1,1,jrs),dzqz(1,1,0),dzzqz(1,1,0),kmp1)
      call get_thick(tdepth(1,1,jrn),dzqz(1,1,1),dzzqz(1,1,1),kmp1)
#else
      call get_thick (j,tgrid,dzqz(1,1,0),dzzqz(1,1,0),kmp1)
      jptr=min(j+1,jmt)
      call get_thick (jptr,tgrid,dzqz(1,1,1),dzzqz(1,1,1),kmp1)
#endif
c
c  Set tracer points auxillary arrays used in vertical differences.
c
      do 20 k=1,km
        do 10 i=1,imt
          dz2rqz(i,k,0)=p5/dzqz(i,k,0)
          dzz2rqz(i,k,0)=p5/dzzqz(i,k,0)
          dz2rqz(i,k,1)=p5/dzqz(i,k,1)
          dzz2rqz(i,k,1)=p5/dzzqz(i,k,1)
  10    continue
  20  continue
c
c  Upper and lower vertical diffusion grid factors at the T points.
c
      do 40 k=1,km
        do 30 i=1,imt
          dzturq(i,k)=c1/(dzqz(i,k,0)*dzzqz(i,k,0))
          dztlrq(i,k)=c1/(dzqz(i,k,0)*dzzqz(i,k+1,0))
  30    continue
  40  continue
c
c-----------------------------------------------------------------------
c  Set new U,V points depths and current vertical spacing and vertical
c  thicknesses arrays.
c-----------------------------------------------------------------------
c
c-- temporary calls to get xvqz
      jptr=min(j+1,jmt)
      call depthslab(jptr,vgrid,xvdepth)
#ifdef gridold
      call get_thick(xvdepth,  xzvqz  ,dzzvqz(1,1,0),kmp1)
#else
      call get_thick (jptr,vgrid,xzvqz,dzzvqz(1,1,0),kmp1)
#endif
c--- end temporary calls
c
      jnew=jnew-1
      jptr=max(jnew,1)
      call depthslab(jptr,vgrid,vdepth(1,1,newslab))
#ifdef gridold
      call get_thick(vdepth(1,1,jrn),dzvqz(1,1,0),dzzvqz(1,1,0),kmp1)
      call get_thick(vdepth(1,1,jrs),dzvqz(1,1,1),dzzvqz(1,1,1),kmp1)
#else
      call get_thick (j,vgrid,dzvqz(1,1,0),dzzvqz(1,1,0),kmp1)
      jptr=max(j-1,1)
      call get_thick (jptr,vgrid,dzvqz(1,1,1),dzzvqz(1,1,1),kmp1)
#endif
c
c  Set U,V points auxillary arrays used in vertical differences.
c
      do 60 k=1,km
        do 50 i=1,imt
          dzv2rqz(i,k)=p5/dzvqz(i,k,0)
  50    continue
  60  continue
c
c  Upper and lower vertical diffussion grid factor at U,V points.
c
      do 80 k=1,km
        do 70 i=1,imt
          dzvurq(i,k)=c1/(dzvqz(i,k,0)*dzzvqz(i,k,0))
          dzvlrq(i,k)=c1/(dzvqz(i,k,0)*dzzvqz(i,k+1,0))
  70    continue
  80  continue
      return
      end
