      subroutine shap_mean (iopt)
c
c=======================================================================
c                                                                    ===
c  This routine adds and removes mean to tracer fields               ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c    IOPT    Job control.  [0] remove mean  [1] add mean   (integer) ===
c                                                                    ===
c    Common Blocks:                                                  ===
c                                                                    ===
c    /VOLDAT/                                                        ===
c                                                                    ===
c      XT    Tracer fields at TAU+1 time level.       (real array)   ===
c      XT0   Storage array for "bias" tracer fields   (real array)   ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c    Common Blocks:                                                  ===
c                                                                    ===
c    /VOLDAT/                                                        ===
c                                                                    ===
c      XT    Tracer fields at TAU+1 time level.       (real array)   ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <voldat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer iopt
      integer ii,jj,k,n,ip
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      if(iopt.eq.0) then
c
         do 10 n=1,nt
         do 10 k=1,km
         do 10 jj=1,jmt
         do 10 ii=1,imt
            ip=ii+(jj-1)*imt
            xt(ip,k,n)=xt(ip,k,n)-xt0(ii,jj,k,n)
 10      continue
c
      elseif(iopt.eq.1) then
c
         do 20 n=1,nt
         do 20 k=1,km
         do 20 jj=1,jmt
         do 20 ii=1,imt
            ip=ii+(jj-1)*imt
            xt(ip,k,n)=xt(ip,k,n)+xt0(ii,jj,k,n)
 20      continue
c
      endif
c
      return
      end
