      subroutine sig_search(look_up,i,j,sig,sig_vol,st_lev,levup,levdn,
     *                      zup,zdn,found)
c
c=======================================================================
c                                                                    ===
c  This routine finds the nearest level, in the supplied direction,  ===
c  whose density anomalies bracket the given density anomaly.        ===
c                                                                    ===
c     On Input:                                                      ===
c                                                                    ===
c     I, J     point at which column is located (grid units; real)   ===
c     LOOK_UP  indicates which direction to travel levels (logical)  ===
c              LOOK_UP = .true.   ->  move up the column             ===
c              LOOK_UP = .false.  ->  move down the comumn           ===
c     SIG      the desired density anomaly (real)                    ===
c     SIG_VOL  densities at every gridpoint (real array)             ===
c     ST_LEV   level to start search (integer)                       ===
c                                                                    ===
c     On Output:                                                     ===
c                                                                    ===
c     FOUND    indicates whether bracketting levels were found       ===
c              (logical)                                             ===
c              FOUND = .true.   ->  levels were found                ===
c              FOUND = .false.  ->  levels were not found            ===
c     LEVDN    number of lower bracketting level (integer)           ===
c     LEVUP    number of upper bracketting level (integer)           ===
c     ZDN      depth at lower bracketting level (real)               ===
c     ZUP      depth at upper bracketting level (real)               ===
c                                                                    ===
c     Calls:      DEPTHSLAB                                          ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical found,look_up,out_range
      integer end_lev,i,incr,j,levdn,levup,st_lev
      FLOAT
     *      sig,sigmax,sigmin,zdn,zup
      FLOAT
     *      sig_vol(imt,jmtm1,km),zslab(imt,km)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  Initialize search parameters.
c-----------------------------------------------------------------------
c
      if(look_up) then
        incr=-1
        levdn=st_lev
        end_lev=2
      else
        incr=1
        levdn=st_lev+1
        end_lev=km
      endif
      levup=levdn-1
c
c-----------------------------------------------------------------------
c  Search levels.
c-----------------------------------------------------------------------
c
      if((levup.gt.0).and.(levdn.le.km)) then
c
c-----------------------------------------------------------------------
c  Range is legal, can begin search.
c-----------------------------------------------------------------------
c
        sigmax=max(sig_vol(i,j,levup),sig_vol(i,j,levdn))
        sigmin=min(sig_vol(i,j,levup),sig_vol(i,j,levdn))
        out_range=(sig.lt.sigmin).or.(sig.gt.sigmax)
        do 10 while (out_range.and.(levdn.ne.end_lev))
          levdn=levdn+incr
          levup=levup+incr
          sigmax=max(sig_vol(i,j,levup),sig_vol(i,j,levdn))
          sigmin=min(sig_vol(i,j,levup),sig_vol(i,j,levdn))
          out_range=(sig.lt.sigmin).or.(sig.gt.sigmax)
  10    continue
        if(.not.out_range) then
c
c-----------------------------------------------------------------------
c  Found bracketting levels.
c-----------------------------------------------------------------------
c
          call depthslab (j,tgrid,zslab)
          zup=zslab(i,levup)
          zdn=zslab(i,levdn)
          found=.true.
        else
c
c-----------------------------------------------------------------------
c  Failed to find bracketting levels.
c-----------------------------------------------------------------------
c
          found=.false.
        endif
      else
c
c-----------------------------------------------------------------------
c  Illegal search range.
c-----------------------------------------------------------------------
c
        found=.false.
      endif
      return
      end
