      subroutine step
c
c=======================================================================
c                                                                    ===
c  STEP is called  once  per timestep.   It initializes various      ===
c       quantities, bootstraps the basic row by row computation      ===
c       of prognostic variables, manages the I/O for the latter,     ===
c       and   performs  various   analysis  procedures  on  the      ===
c       progressing solution.                                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fullwd.h>
#include <scalar.h>
#include <onedim.h>
#include <fields.h>
#include <workspa.h>
#include <bndata.h>
#ifdef shapiro
# include <voldat.h>
# include <filtdat.h>
#endif
#include <options.h>
#ifdef oias
# include <oiopts.h>
#endif
#include <iounits.h>
#include <hybrid.h>
#include <vertslabs.h>
#include <extra.h>
#include <cdiag.h>
#if defined ldrifters & defined rmdenbar
# include <rhomean.h>
#endif
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
# include <cbiopnh.h>
#endif
#ifdef ext_tide
#  include <tidesp.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,im1,ip1,j,k,m,n,ndiskx
#ifdef shapiro
      integer nn
# if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
      integer ip
# endif
#endif
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
      integer nnegtrc
      FLOAT
     *      negtrc, postrc
#endif
#ifdef peprf
      logical wrtprf
#endif
      FLOAT
     *      diag1,diag2,fx
      FLOAT
     *      boot(imt,lbc),boot_save(imt,lbc)
#if defined usrdiagnostic & defined nesttime
      FLOAT
     &      dcpg(2),dco(2),dlp(2),dtrm(2),dtsr(2),tcpg(2),tco(2),tlp(2),
     &      tmsc(2),tmsc2(2),tmsc3(2),trlx(2),tsn1(2),tsn2(2),ttrm(2),
     &      ttsr(2)
#endif
#ifdef cod_ing
      integer ntimes,norder
#endif
c
#if defined usrdiagnostic & defined nesttime
      data dcpg,dco,dlp,dtrm,dtsr,tcpg,tco,tlp,tmsc,
     &     tmsc2,tmsc3,trlx,tsn1,tsn2,ttrm,ttsr /32*c0/
c
#endif
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c=======================================================================
c  Begin section for the initialization of  ============================
c  various quantities on each timestep      ============================
c=======================================================================
c
c-----------------------------------------------------------------------
c  Update timestep counter and total elapsed time.
c-----------------------------------------------------------------------
c
      itt=itt+1
      ttsec=ttsec+dtts
c
c-----------------------------------------------------------------------
c  Set switches to indicate mixing timestep, to activate diagnostics, to
c  print single line information, and to write out progressing solution.
c-----------------------------------------------------------------------
c
      mixts=.false.
      mxpas2=.false.
#ifdef oias
      if((mod(itt,nmix).eq.1).or.
     *   ((noi.gt.0).and.(ittoi.eq.2))) mixts=.true.
#else
      if(mod(itt,nmix).eq.1) mixts=.true.
#endif
      eots=.true.
      if(mixts.and.eb) eots=.false.
      diagts=.false.
      if(mod(itt-1,nnergy).eq.0) diagts=.true.
      prntsi=.false.
      if(mod(itt,ntsi).eq.0) prntsi=.true.
      wrtts=.false.
      if(mod(itt-1,ntsout).eq.0) wrtts=.true.
c
c-----------------------------------------------------------------------
c  If appropriate, read in new boundary information.
c-----------------------------------------------------------------------
c
      call infld(0)
c
c-----------------------------------------------------------------------
c  Update permuting disc I/O units.
c-----------------------------------------------------------------------
c
      ndiskb=mod(itt+2,3)+1
      ndisk =mod(itt+0,3)+1
      ndiska=mod(itt+1,3)+1
c
c-----------------------------------------------------------------------
c  Adjust various quantities for mixing timestep.
c-----------------------------------------------------------------------
c
      mxp=0
      if(mixts) then
        mix=1
        c2dtts=dtts
        c2dtuv=dtuv
        c2dtsf=dtsf
        do 10 j=1,jmt
        do 10 i=1,imt
          pb(i,j)=p(i,j)
  10    continue
      else
        mix=0
        c2dtts=c2*dtts
        c2dtuv=c2*dtuv
        c2dtsf=c2*dtsf
      endif
#ifdef oias
c
c  If this is the end of an assimilation cycle, deactivate assimilation
c  switch ITTOI.
c
      if((noi.gt.0).and.(ittoi.eq.2)) then
        ittoi=0
        write(stdout,*) ' End of assimilation cycle = ',icoi-1
      endif
#endif
c
  20  continue
c
c-----------------------------------------------------------------------
c  Establish over dimensioned arrays for vectorization.
c-----------------------------------------------------------------------
c
      do 30 k=1,km
      do 30 i=1,imt
        dxtq  (i,k)=dxt  (i)
        dxt4rq(i,k)=dxt4r(i)
        dxuq  (i,k)=dxu  (i)
        dxu2rq(i,k)=dxu2r(i)
  30  continue
c
c-----------------------------------------------------------------------
c  Get depths and vertical thicknesses at tracer points (rows=1,2)
c  and velocity points (row=1).
c-----------------------------------------------------------------------
c
#if defined ext_tide 
c-----------------------------------------------------------------------
c  Compute tidal velocities along row J=1
c-----------------------------------------------------------------------
c
      call get_tide (1)
# if  defined advtide
c-----------------------------------------------------------------------
c  Compute change in box vert. thickness due to free surf. displacement
c-----------------------------------------------------------------------
c
      call reset_t_thickness
# endif
#endif
      call setvert(1)
c
c-----------------------------------------------------------------------
c  Queue up disk reads for this timestep.
c-----------------------------------------------------------------------
c
      do 40 j=1,jmtm1
        call ofind(labs(ndiskb),nslab,(j-1)*nslab+1)
        call ofind(labs(ndisk),nslab,(j-1)*nslab+1)
  40  continue
c
c-----------------------------------------------------------------------
c  Initialize variables associated with energy diagnostics.
c-----------------------------------------------------------------------
c
      if(prntsi) then
        do 60 j=1,jmt
        do 60 k=0,km
          ektot(k,j)=c0
          do 50 m=1,nt
            dtabs(k,m,j)=c0
  50      continue
  60    continue
      endif
      if(diagts.and.eots.and.wnetcdf) call diag(1)
c
c=======================================================================
c  End of section for initialization  ==================================
c=======================================================================
c
c=======================================================================
c  Begin a bootstrap procedure to prepare for the  =====================
c  row-by-row computation of prognostic variables  =====================
c=======================================================================
c
c-----------------------------------------------------------------------
c  Fetch data for row 2 from the disc.
c-----------------------------------------------------------------------
c
      call oget(labs(ndiskb),nslab,     +1,tb)
      call oget(labs(ndisk ),nslab,     +1,t )
      call oget(labs(ndiskb),nslab,nslab+1,tbp)
      call oget(labs(ndisk ),nslab,nslab+1,tp )
c
c-----------------------------------------------------------------------
c  Switch slab incidental data into correct slab after read in.
c-----------------------------------------------------------------------
c
      if(mod(itt,2)+mxp.ne.1) then
        do 70 i=1,imt
          bcon(i,1)=fkmup(i)
          fkmup(i)=fkmtp(i)
          fkmtp(i)=bcon(i,1)
          boot(i,1)=fkmu(i)
          fkmu(i)=fkmt(i)
          fkmt(i)=boot(i,1)
  70    continue
        do 80 i=1,imt
          bcon(i,2)=wsyp(i)
          wsyp(i)=wsxp(i)
          wsxp(i)=bcon(i,2)
          boot(i,2)=wsy(i)
          wsy(i)=wsx(i)
          wsx(i)=boot(i,2)
  80    continue
        do 83 i=1,imt
          boot_save(i,1)=bcon(i,1)
          boot_save(i,2)=bcon(i,2)
  83    continue
      else
        do 87 i=1,imt
          boot_save(i,1)=fkmu(i)
          boot_save(i,2)=wsy(i)
  87    continue
      endif
c
c-----------------------------------------------------------------------
c  Convert maximum level indicators to integers.
c-----------------------------------------------------------------------
c
      do 90 i=1,imt
        kmtp(i)=fkmtp(i)
        kmup(i)=fkmup(i)
  90  continue
c
c-----------------------------------------------------------------------
c  Move TAU-1 data to TAU level on a mixing timestep.
c-----------------------------------------------------------------------
c
      if(mixts) then
        do 100 m=1,nt
        do 100 k=1,km
        do 100 i=1,imt
          tbp(i,k,m)=tp(i,k,m)
          tb(i,k,m)=t(i,k,m)
 100    continue
        do 110 k=1,km
        do 110 i=1,imt
          ubp(i,k)=up(i,k)
          vbp(i,k)=vp(i,k)
          ub(i,k)=u(i,k)
          vb(i,k)=v(i,k)
 110    continue
      endif
#ifdef ldrifters
c
c-----------------------------------------------------------------------
c  Load first two slabs of density into volume storage (for drifters).
c-----------------------------------------------------------------------
c
      call state(t(1,1,1),t(1,1,2),tdepth(1,1,jrs),rhos)
      call state(tp(1,1,1),tp(1,1,2),tdepth(1,1,jrn),rhon)
# ifdef rmdenbar
      do 120 k=1,km
      do 120 i=1,imt
        rhos(i,k)=rhos(i,k)-rhobar(i,1,k)
        rhon(i,k)=rhon(i,k)-rhobar(i,2,k)
 120  continue
# endif
      call load_sig(1,rhos)
      call load_sig(2,rhon)
#endif
c
c-----------------------------------------------------------------------
c  Initialize arrays for first calls to CLINIC and TRACER.
c-----------------------------------------------------------------------
c
      do 130 k=1,km
      do 130 i=1,imt
        fvst(i,k)=c0
        rhos(i,k)=c0
        rhon(i,k)=c0
        fmm (i,k)=c0
        fm  (i,k)=c0
        gm  (i,k)=c0
        Umet(i,k)=c0
        Uxx (i,k)=c0
        Uyy (i,k)=c0
        Vmet(i,k)=c0
        Vxx (i,k)=c0
        Vyy (i,k)=c0
        Txx (i,k)=c0
        Tyy (i,k)=c0
 130  continue
c
c-----------------------------------------------------------------------
c  Construct mask array for row J=2 tracers.
c-----------------------------------------------------------------------
c
      do 140 k=1,km
      do 140 i=1,imt
        if(kmtp(i).ge.kar(k)) then
          fmp(i,k)=c1
        else
          fmp(i,k)=c0
        endif
 140  continue
c
c-----------------------------------------------------------------------
c  Set vorticity computation arrays at southern wall.
c-----------------------------------------------------------------------
c
      do 150 i=1,imt
        zus(i)=c0
        zvs(i)=c0
 150  continue
c
c-----------------------------------------------------------------------
c  Save internal mode velocities for row J=2 and compute advective
c  coefficient for south face of row J=2 U,V boxes.
c-----------------------------------------------------------------------
c
      fx=dyu2r(2)*csr(2)*cst(2)
      do 160 k=1,km
      do 160 i=1,imt
        ucl(i,k)=u(i,k)
        vcl(i,k)=v(i,k)
        uclb(i,k)=ub(i,k)
        vclb(i,k)=vb(i,k)
        uclp(i,k)=up(i,k)
        vclp(i,k)=vp(i,k)
        uclbp(i,k)=ubp(i,k)
        vclbp(i,k)=vbp(i,k)
        ip1=min(i+1,imt)
        fvsu(i,k)=((vp(i,k)*xzvqz(i,k)+v(i,k)*dzvqz(i,k,0))*p5+
     *          (xzvqz(i,k)+dzvqz(i,k,0))*(p(ip1,2)-p(i,2))*dxur(i)/
     *            (hdv(i,2)+hdv(i,1))*cstr(2)*min(c1,fkmu(i),fkmup(i))
     *            )*fx
 160  continue
c
c-----------------------------------------------------------------------
c  Compute external mode velocities for row J=1.
c-----------------------------------------------------------------------
c
c  1st, compute for TAU-1 time level.
c
      do 170 i=1,imtm1
        diag1=pb(i+1,2)-pb(i,1)
        diag2=pb(i,2)-pb(i+1,1)
        ubarb(i)=-(diag1+diag2)*dyu2r(1)*min(c1,fkmu(i))*hv(i,1)
        vbarb(i)= (diag1-diag2)*dxu2r(i)*min(c1,fkmu(i))*hv(i,1)*csr(1)
 170  continue
#ifdef cyclic
      ubarb(1  )=ubarb(imtm1)
      vbarb(1  )=vbarb(imtm1)
      ubarb(imt)=ubarb(2    )
      vbarb(imt)=vbarb(2    )
#endif
c
c  2nd, compute for TAU time level.
c
      do 180 i=1,imtm1
        diag1=p(i+1,2)-p(i,1)
        diag2=p(i,2)-p(i+1,1)
        ubar(i)=-(diag1+diag2)*dyu2r(1)*min(c1,fkmu(i))*hv(i,1)
        vbar(i)= (diag1-diag2)*dxu2r(i)*min(c1,fkmu(i))*hv(i,1)*csr(1)
 180  continue
#ifdef cyclic
      ubar(1  )=ubar(imtm1)
      vbar(1  )=vbar(imtm1)
      ubarb(imt)=ubar(2    )
      vbar(imt)=vbar(2    )
#endif
c
c-----------------------------------------------------------------------
c  Add internal mode to external mode for row J=1.
c-----------------------------------------------------------------------
c
      do 190 k=1,km
      do 190 i=1,imu
        ub(i,k)=ub(i,k)+ubarb(i)
        vb(i,k)=vb(i,k)+vbarb(i)
        u(i,k)=u(i,k)+ubar(i)
        v(i,k)=v(i,k)+vbar(i)
        im1=max(i-1,1)
#if !defined ext_tide | !defined advtide
        fvst(i,k)=(v(i,k)*dxuq(i,k)*dzvqz(i,k,0)+
     *            v(im1,k)*dxuq(im1,k)*dzvqz(im1,k,0))*
     *            cstr(1)*dytr(1)*cs(1)*dxt4rq(i,k)
 190  continue
#else
        fvst(i,k)=(v(i,k)*dxuq(i,k)*dzvqz(i,k,0)*ustretch(i,1)+
     *            v(im1,k)*dxuq(im1,k)*dzvqz(im1,k,0)*ustretch(im1,1))*
     *            cstr(1)*dytr(1)*cs(1)*dxt4rq(i,k)
 190  continue
c
c-----------------------------------------------------------------------
c  Compute tidal contributions for row J=1.
c-----------------------------------------------------------------------
c
      do 200 k=1,km
      do 200 i=1,imu
        im1=max(i-1,1)
        fvstdt(i,k)=
     *        (vtide (i  ,k)*dxuq(i  ,k)*dzvqz(i  ,k,0)*ustretch(i,1)+
     *       vtide (im1,k)*dxuq(im1,k)*dzvqz(im1,k,0)*ustretch(im1,1))*
     *                                 cstr(1)*dytr(1)*cs(1)*dxt4rq(i,k)
# ifdef advtide0
       fvstdt(i,k)=fvstdt(i,k)*sadv
# endif
 200  continue
c
#endif
c
c-----------------------------------------------------------------------
c  Compute external mode velocities for row J=2.
c-----------------------------------------------------------------------
c
c  1st, compute for TAU-1 time level.
c
      j=1
      do 210 i=1,imtm1
        diag1=pb(i+1,j+2)-pb(i  ,j+1)
        diag2=pb(i  ,j+2)-pb(i+1,j+1)
        ubarb(i)=-(diag1+diag2)*dyu2r(j+1)*min(c1,fkmup(i))*hv(i,j+1)
        vbarb(i)= (diag1-diag2)*dxu2r(i  )*min(c1,fkmup(i))*hv(i,j+1)*
     *            csr(j+1)
 210  continue
#ifdef cyclic
      ubarb(1  )=ubarb(imtm1)
      vbarb(1  )=vbarb(imtm1)
      ubarb(imt)=ubarb(2    )
      vbarb(imt)=vbarb(2    )
#endif
c
c  2nd, compute for tau time level
c
      do 220 i=1,imtm1
        diag1=p (i+1,j+2)-p (i  ,j+1)
        diag2=p (i  ,j+2)-p (i+1,j+1)
        ubar (i)=-(diag1+diag2)*dyu2r(j+1)*min(c1,fkmup(i))*hv(i,j+1)
        vbar (i)= (diag1-diag2)*dxu2r(i  )*min(c1,fkmup(i))*hv(i,j+1)*
     *            csr(j+1)
 220  continue
#ifdef cyclic
      ubar(1  )=ubar(imtm1)
      vbar(1  )=vbar(imtm1)
      ubar(imt)=ubar(2    )
      vbar(imt)=vbar(2    )
#endif
c
c-----------------------------------------------------------------------
c  Add external mode to internal mode for row J=2  (ocean points only).
c-----------------------------------------------------------------------
c
      do 230 k=1,km
      do 230 i=1,imu
        if(kmup(i).ge.kar(k)) then
          ubp(i,k)=ubp(i,k)+ubarb(i)
          vbp(i,k)=vbp(i,k)+vbarb(i)
          up (i,k)=up (i,k)+ubar (i)
          vp (i,k)=vp (i,k)+vbar (i)
        endif
 230  continue
c
c-----------------------------------------------------------------------
c  Compute external mode for TAU-1 time level for j=1
c-----------------------------------------------------------------------
c
      do 240 i=1,imtm1
        diag1=pb(i+1,j+1)-pb(i  ,j)
        diag2=pb(i  ,j+1)-pb(i+1,j)
        ubarbm(i)=-(diag1+diag2)*dyu2r(j)*min(c1,fkmu(i))*hv(i,j)
        vbarbm(i)= (diag1-diag2)*dxu2r(i  )*min(c1,fkmu(i))*hv(i,j)*
     *            csr(j)
 240  continue
#ifdef cyclic
      ubarbm(1  )=ubarbm(imtm1)
      vbarbm(1  )=vbarbm(imtm1)
      ubarbm(imt)=ubarbm(2    )
      vbarbm(imt)=vbarbm(2    )
#endif
c
c  2nd, compute for tau time level
c
      do 250 i=1,imtm1
        diag1=p (i+1,j+1)-p (i  ,j)
        diag2=p (i  ,j+1)-p (i+1,j)
        ubarm(i)=-(diag1+diag2)*dyu2r(j+1)*min(c1,fkmu(i))*hv(i,j)
        vbarm(i)= (diag1-diag2)*dxu2r(i  )*min(c1,fkmu(i))*hv(i,j)*
     *            csr(j)
 250  continue
#ifdef cyclic
      ubarm(1  )=ubarm(imtm1)
      vbarm(1  )=vbarm(imtm1)
      ubarm(imt)=ubarm(2    )
      vbarm(imt)=vbarm(2    )
#endif
c
c-----------------------------------------------------------------------
c  Set vertical boundary conditions (surface and bottom) for momentum
c  and tracer at row J=1.
c-----------------------------------------------------------------------
c
#ifndef analytical
      call setvbc(1)
#else
      call anavbc(1)
#endif
c
c-----------------------------------------------------------------------
c  Set vertical mixing coefficients for row J=1.
c-----------------------------------------------------------------------
c
#ifdef ppvmix
      call ppmix(1)
#else
      call cnvmix(1)
#endif
#ifdef peprf
c
c-----------------------------------------------------------------------
c  For southernmost slab, write any requested profiles in ASCII format.
c-----------------------------------------------------------------------
c
        call time_prf (itt,wrtprf)
        if (wrtprf) call slab_prf (itt,1)
#endif
c
c=======================================================================
c  End of bootstrap procedure  =========================================
c=======================================================================
c
c=======================================================================
c  Begin row-by-row computation of prognostic variables  ===============
c=======================================================================
#if defined usrdiagnostic & defined nesttime
c
      do j = 1, 2
         tcpg(j) = c0
         tco(j) = c0
         tlp(j) = c0
         ttrm(j) = c0
         ttsr(j) = c0
         tsn1(j) = c0
         tsn2(j) = c0
      enddo
      call dtime (tmsc)
#endif
c
      do 450 j=2,jmtm2
c
c-----------------------------------------------------------------------
c  Set boundary conditions and then save slabs
c-----------------------------------------------------------------------
c
        if(j.gt.2) then
#ifndef cyclic
c
c  Set western and eastern lateral boundary conditons on UA,VA,TA,P,ZTD
c  for row=J-1.
c
          call boundary(j-1,1)
#endif
c
c  Reset southern boundary condition for vorticity tendency
c
          if(j.eq.4.and.iopt(4).eq.3) then
             call zrobc_ori(j,south)
          endif
c
c  Save data for row=J-1.
c
#ifdef shapiro
          call osav(j-1)
#else
# if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c
c  Check for negative tracers, print warning if found.
c
          if ((biopos.eq.3).or.(iopt(5).ne.0)) then
             do 270 m=3,nt
                nnegtrc=0
                negtrc=c0
                postrc=c0
                do 260 k=1,km
                do 260 i=1,imt
                   if(ta(i,k,m).lt.c0) then
                      nnegtrc=nnegtrc+1
                      negtrc=negtrc+ta(i,k,m)
                   else
                      postrc=postrc+ta(i,k,m)
                   endif
 260            continue
                if (nnegtrc.gt.0) then 
                   write(stdout,900)nnegtrc,m
                   write(stdout,910)negtrc,postrc
                   if(biopos.eq.3) call exitus('STEP')
                endif
 270         continue
          endif
c
c  Insure non-negative biological tracers of row=J-1.
c
          if(biopos.eq.1) then
            do 280 m=3,nt
            do 280 k=1,km
            do 280 i=1,imt
              ta(i,k,m)=max(c0,ta(i,k,m))
 280        continue
          endif
# endif
# if defined nest2larger | defined nest2smaller | defined AsselinFilt
          call osav(j-1)
# else
          call oput(labs(ndiska),nslab,(j-2)*nslab+1,ta)
# endif
#endif
        endif
c
        if(j.eq.3) then
c
c  Set southern lateral boundary conditions on UA,VA,TA,P,ZTD.
c
           call setvert(1)
           call boundary(1,2)
           call setvert(j-1)
c
c  Set incidental data for row 1 and save present values in boot
c
          do 285 i=1,imt
            boot(i,1)=bcon(i,1)
            boot(i,2)=bcon(i,2)
            bcon(i,1)=boot_save(i,1)
            bcon(i,2)=boot_save(i,2)
 285      continue
c
c  Save data for row=1.
c
#ifdef shapiro
          call osav(1)
#else
# if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c
c  Check for negative tracers, print warning if found.
c
          if ((biopos.eq.3).or.(iopt(5).ne.0)) then 
             do 300 m=3,nt
                nnegtrc=0
                negtrc=c0
                postrc=c0
                do 290 k=1,km
                do 290 i=1,imt
                   if(ta(i,k,m).lt.c0) then
                      nnegtrc=nnegtrc+1
                      negtrc=negtrc+ta(i,k,m)
                   else
                      postrc=postrc+ta(i,k,m)
                   endif
 290            continue
                if (nnegtrc.gt.0) then 
                   write(stdout,900)nnegtrc,m
                   write(stdout,910)negtrc,postrc
                   if(biopos.eq.3) call exitus('STEP')
                endif
 300         continue
          endif
c     
c  Insure non-negative biological tracers for row=2.
c
          if(biopos.eq.1) then
            do 310 m=3,nt
            do 310 k=1,km
            do 310 i=1,imt
              ta(i,k,m)=max(c0,ta(i,k,m))
 310        continue
          endif
# endif
# if defined nest2larger | defined nest2smaller | defined AsselinFilt
          call osav(1)
# else
          call oput(labs(ndiska),nslab,1,ta)
# endif          
#endif
c
c  Reset incidental data from values saved in boot.
c
          do 315 i=1,imt
             bcon(i,1)=boot(i,1)
             bcon(i,2)=boot(i,2)
 315      continue
        endif
c
c-----------------------------------------------------------------------
c  Move all slab data down one row.
c-----------------------------------------------------------------------
c
        do 320 n=1,nt
        do 320 k=1,km
        do 320 i=1,imt
          tbm(i,k,n)=tb (i,k,n)
          tm (i,k,n)=t  (i,k,n)
          tb (i,k,n)=tbp(i,k,n)
          t  (i,k,n)=tp (i,k,n)
 320    continue
        do 330 k=1,km
        do 330 i=1,imt
          ubm(i,k)=ub (i,k)
          vbm(i,k)=vb (i,k)
          um (i,k)=u  (i,k)
          vm (i,k)=v  (i,k)
          ub (i,k)=ubp(i,k)
          vb (i,k)=vbp(i,k)
          u  (i,k)=up (i,k)
          v  (i,k)=vp (i,k)
#ifdef ext_tide
          utidem(i,k)=utide (i,k)
          vtidem(i,k)=vtide (i,k)
          utide (i,k)=utidep(i,k)
          vtide (i,k)=vtidep(i,k)
#endif
 330    continue
        do 340 i=1,imt
          fkmum(i)=fkmu (i)
          wsym (i)=wsy  (i)
          fkmtm(i)=fkmt (i)
          wsxm (i)=wsx  (i)
          fkmu (i)=fkmup(i)
          wsy  (i)=wsyp (i)
          fkmt (i)=fkmtp(i)
          wsx  (i)=wsxp (i)
#ifdef ext_tide
          btide (i)=btidep(i)
#endif
 340    continue
c
#ifdef close_tracers
c-----------------------------------------------------------------------
c     If requested, impose closed boundary conditions on tracers on
c     southern and northern boundaries.
c-----------------------------------------------------------------------
c
        if ((j.eq.2).and.(iopt(1).eq.0)) then
          do 350 n=1,nt
          do 350 k=1,km
          do 350 i=1,imt
            tm (i,k,n)=t  (i,k,n)
 350      continue
        end if
c
        if ((j.eq.jmtm2).and.(iopt(1).eq.0)) then
          do 360 n=1,nt
          do 360 k=1,km
          do 360 i=1,imt
            tp (i,k,n)=t  (i,k,n)
 360      continue
        end if
c
#endif
c-----------------------------------------------------------------------
c  Complete read in of J+1 slab.
c-----------------------------------------------------------------------
c
        call oget(labs(ndiskb),nslab,j*nslab+1,tbp)
        call oget(labs(ndisk ),nslab,j*nslab+1,tp )
c
c-----------------------------------------------------------------------
c  Switch slab incidental data into correct slab after read in.
c-----------------------------------------------------------------------
c
        if(mod(itt,2)+mxp.ne.1) then
          do 370 i=1,imt
            bcon(i,1)=fkmup(i)
            fkmup(i)=fkmtp(i)
            fkmtp(i)=bcon(i,1)
            bcon(i,2)=wsyp(i)
            wsyp(i)=wsxp(i)
            wsxp(i)=bcon(i,2)
 370      continue
        endif
c
c-----------------------------------------------------------------------
c  Shift maximum level indicators down one row and set J+1 values.
c-----------------------------------------------------------------------
c
        do 380 i=1,imt
          kmt (i)=kmtp (i)
          kmu (i)=kmup (i)
          kmtp(i)=fkmtp(i)
          kmup(i)=fkmup(i)
          if(j.eq.jmtm2) kmtp(i)=kmt(i)
          if(j.eq.jmtm2) kmup(i)=kmu(i)
 380    continue
c
c-----------------------------------------------------------------------
c  Move TAU-1 data to TAU level on a mixing timestep.
c-----------------------------------------------------------------------
c
        if(mixts) then
          do 390 m=1,nt
          do 390 k=1,km
          do 390 i=1,imt
            tbp(i,k,m)=tp(i,k,m)
 390      continue
          do 400 k=1,km
          do 400 i=1,imt
            ubp(i,k)=up(i,k)
            vbp(i,k)=vp(i,k)
 400      continue
        endif
c
c-----------------------------------------------------------------------
c  Shift masks down one row and compute new masks.
c-----------------------------------------------------------------------
c
        do 410 k=1,km
        do 410 i=1,imt
          fmm(i,k)=fm (i,k)
          fm (i,k)=fmp(i,k)
 410    continue
        do 420 k=1,km
        do 420 i=1,imt
          if(kmtp(i).ge.kar(k)) then
            fmp(i,k)=c1
          else
            fmp(i,k)=c0
          endif
          if(kmu(i).ge.kar(k)) then
            gm(i,k)=c1
          else
            gm(i,k)=c0
          endif
 420    continue
c
c-----------------------------------------------------------------------
c  Get depths and vertical thicknesses at the tracer points (row=J,J+1)
c  and velocity points (row=J,J-1).
c-----------------------------------------------------------------------
c
        call setvert(j)
c
c-----------------------------------------------------------------------
c  Set vertical boundary conditions (surface and bottom) for momentum
c  and tracers.
c-----------------------------------------------------------------------
c
#ifndef analytical
        call setvbc(j)
#else
        call anavbc(j)
#endif
#ifdef ext_tide
c-----------------------------------------------------------------------
c  Compute tidal velocities along row J
c-----------------------------------------------------------------------
c
      call get_tide (j)
c
#endif
c
c-----------------------------------------------------------------------
c  Set vertical mixing coefficients.
c-----------------------------------------------------------------------
c
#ifdef ppvmix
        call ppmix(j)
#else
        call cnvmix(j)
#endif
c
c-----------------------------------------------------------------------
c  Monitor velocities at the current time level.
c-----------------------------------------------------------------------
c
        call cfl(j)
c
c-----------------------------------------------------------------------
c  Call the main computational routines to update the row.
c-----------------------------------------------------------------------
c
#if !defined usrdiagnostic | !defined nesttime
        call clinic(j)
        call tracer(j)
#else
        call dtime (dlp)
        call clinic(j,dcpg,dco)
        call tracer(j,dtsr,dtrm)
        do n = 1, 2
           tcpg(n) = tcpg(n) + dcpg(n)
           tco(n)  = tco(n) + dco(n)
           tlp(n)  = tlp(n) + dlp(n)
           ttrm(n) = ttrm(n) + dtrm(n)
           ttsr(n) = ttsr(n) + dtsr(n)
        enddo
#endif
c
c-----------------------------------------------------------------------
c  Calculate diagnostics on diagnostic timesteps.  Only if number of
c  output levels NLEV is greater than zero.
c-----------------------------------------------------------------------
c
        if(diagts.and.eots.and.wnetcdf) call diag(j)
c
#if defined analytical
c-----------------------------------------------------------------------
c  Report other User dependent diagnostics.
c-----------------------------------------------------------------------
c
        if(eots) call anadiag(j)
c
# elif defined usrdiagnostic & !defined nesttime
c-----------------------------------------------------------------------
c  Report other User dependent diagnostics.
c-----------------------------------------------------------------------
c
        if(eots) call userdiag(j)
c
#endif
c-----------------------------------------------------------------------
c  Write out the progressing solution at specified rows on energy TSTEP.
c  Only if number of output levels NLEV is greater than zero.
c-----------------------------------------------------------------------
c
        if(wrtts.and.eots.and.wnetcdf) call cdfout(j)
#ifdef peprf
c
c-----------------------------------------------------------------------
c  For current slab, write any requested profiles in ASCII format.
c-----------------------------------------------------------------------
c
        if (wrtprf) call slab_prf (itt,j)
#endif
c
c-----------------------------------------------------------------------
c  Put slab incidental data into correct slab for writeout.
c-----------------------------------------------------------------------
c
        if(mod(itt,2).eq.0) then
          do 430 i=1,imt
            bcon(i,1)=fkmt(i)
            bcon(i,2)=wsx(i)
 430      continue
        else
          do 440 i=1,imt
            bcon(i,1)=fkmu(i)
            bcon(i,2)=wsy(i)
 440      continue
        endif
#ifdef ldrifters
c
c-----------------------------------------------------------------------
c  Load density for slab J+1 into volume storage for drifters.
c-----------------------------------------------------------------------
c
        call load_sig(j+1,rhon)
#endif
 450  continue
c
#if defined usrdiagnostic & defined nesttime
        call dtime (dlp)
        tlp(1) = tlp(1) + dlp(1)
        tlp(2) = tlp(2) + dlp(2)
c
#endif
c=======================================================================
c  End row-by-row computation  =========================================
c=======================================================================
c
c-----------------------------------------------------------------------
c  Modify UA,VA,TA at I=1,I=IMT (IMTM1)  boundaries and
c  save newly computed data from the final row.
c-----------------------------------------------------------------------
#ifndef cyclic
c
c  Set western and eastern lateral boundary conditons on UA,VA,TA,P,ZTD
c  for row=JMTM2.
c
      call boundary(jmtm2,1)
#endif
c
c  Save data for row=JMTM2
c
#ifdef shapiro
      call osav(jmtm2)
#else
# if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c
c  Check for negative tracers, print warning if found.
c
      if ((biopos.eq.3).or.(iopt(5).ne.0)) then 
         do 470 m=3,nt
            nnegtrc=0
            negtrc=c0
            postrc=c0
            do 460 k=1,km
            do 460 i=1,imt
               if(ta(i,k,m).lt.c0) then
                  nnegtrc=nnegtrc+1
                  negtrc=negtrc+ta(i,k,m)
               else
                  postrc=postrc+ta(i,k,m)
               endif
 460        continue
            if (nnegtrc.gt.0) then 
               write(stdout,900)nnegtrc,m
               write(stdout,910)negtrc,postrc
               if(biopos.eq.3) call exitus('STEP')
            endif
 470     continue
      endif
c
c  Insure non-negative biological tracers for row=JMTM2.
c
      if(biopos.eq.1) then
        do 480 m=3,nt
        do 480 k=1,km
        do 480 i=1,imt
          ta(i,k,m)=max(c0,ta(i,k,m))
 480    continue
      endif
# endif
# if defined nest2larger | defined nest2smaller | defined AsselinFilt
      call osav(jmtm2)
# else
      call oput(labs(ndiska),nslab,(jmt-3)*nslab+1,ta)
# endif
#endif
c
c  Set northern lateral boundary conditons on UA,VA,TA,P,ZTD.
c
      call setvert(jmtm1)
      call boundary(jmtm1,4)
c
c  Save data for row=JMTM1.
c
#ifdef shapiro
      call osav(jmtm1)
#else
# if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c
c  Check for negative tracers, print warning if found.
c
      if ((biopos.eq.3).or.(iopt(5).ne.0)) then 
         do 500 m=3,nt
            nnegtrc=0
            negtrc=c0
            postrc=c0
            do 490 k=1,km
            do 490 i=1,imt
               if(ta(i,k,m).lt.c0) then
                  nnegtrc=nnegtrc+1
                  negtrc=negtrc+ta(i,k,m)
               else
                  postrc=postrc+ta(i,k,m)
               endif
 490        continue
            if (nnegtrc.gt.0) then 
               write(stdout,900)nnegtrc,m
               write(stdout,910)negtrc,postrc
               if(biopos.eq.3) call exitus('STEP')
            endif
 500     continue
      endif
c
c  Insure non-negative biological tracers for row=JMT-1
c
      if(biopos.eq.1) then
        do 510 m=3,nt
        do 510 k=1,km
        do 510 i=1,imt
          ta(i,k,m)=max(c0,ta(i,k,m))
 510    continue
      endif
# endif
# if defined nest2larger | defined nest2smaller | defined AsselinFilt
      call osav(jmtm1)
# else
      call oput(labs(ndiska),nslab,(jmt-2)*nslab+1,ta)
# endif
#endif
#ifdef peprf
c
c-----------------------------------------------------------------------
c  For northernmost slabs, write any requested profiles in ASCII format.
c-----------------------------------------------------------------------
c
        if (wrtprf) call slab_prf (itt,jmtm1)
        if (wrtprf) call slab_prf (itt,jmt)
#endif
#if defined usrdiagnostic & defined nesttime
c
      call dtime (tmsc2)
#endif
#if defined nest2larger | defined nest2smaller
c
c-----------------------------------------------------------------------
# if !defined nest_ext2lrgr & !defined nest_ext2smlr
c  Send and/or receive boundary conditions for barotropic vorticity.
# elif defined nest_ext2lrgr & defined nest_ext2smlr
c  Send and/or receive transport for fine grid
# elif defined nest_ext2lrgr
c  Receive transport from coarse grid. Send barotropic vorticity
c  boundary conditions to fine grid.
# else
c  Receive barotropic vorticity boundary conditions from coarse grid.
c  Send transport to fine grid.
# endif
c  Send and/or receive interior data from smaller grids to larger.
# ifdef nest2larger
c  Receive boundary conditions from larger grid.
# endif
c-----------------------------------------------------------------------
c
# if !defined usrdiagnostic | !defined nesttime
      call nest_t_align (itt)
      call nest_interior (itt)
#  ifdef nest2larger
      call nest_rec_bc (itt)
#  endif
# else
      call nest_t_align (itt,tsn1)
      call nest_interior (itt,tsn1,tsn2)
#  ifdef nest2larger
      call nest_rec_bc (itt,tsn1,tsn2)
#  endif
# endif
#endif
#ifdef shapiro
c
c-----------------------------------------------------------------------
c  If applicable, Shapiro filter the 2-d horizontal velocity and tracers
c  fields.
c-----------------------------------------------------------------------
c
c       ICNTM, ICNTH = counter (for frequency of application)
c       NFRQM, NFRQH = frequency with which filter is applied
c       NTIMM, NTIMH = number of times filter is applied per time step
c       NORDM, NORDH = order of the filter
c
c  Shapiro filter internal mode velocity.
c
      if(mixvel.eq.1) then
        icntv=icntv+1
        if(icntv.ne.nfrqv) goto 530
        if(nordv.eq.0) goto 530
        icntv=0
        do 520 nn=1,ntimv
        do 520 k=1,km
          call shap_lev(xu(1,k),imu,jmtm1,vgrid,nordv)
          call shap_lev(xv(1,k),imu,jmtm1,vgrid,nordv)
 520    continue
 530    continue
      endif
c
c  Shapiro filter tracers.
c
      if(mixtrc.eq.1) then
        icntt=icntt+1
        if(icntt.ne.nfrqt) goto 550
        if(nordt.eq.0) goto 550
        icntt=0
# if defined shapmean & defined pressbias
        call shap_mean(0)
# endif
# ifndef cod_ing
        do 540 nn=1,ntimt
        do 540 m=1,nt
        do 540 k=1,km
#  if defined coast & defined coastedge
          call set_edges(xt(1,k,m),tgrid)
#  endif
          call shap_lev(xt(1,k,m),imt,jmtm1,tgrid,nordt)
#  if defined coast & defined coastedge
          call set_edges(xt(1,k,m),tgrid)
#  endif
 540    continue
# else
        do 540 m=1,nt
        do 540 k=1,km
           if(m.eq.icod) then
              ntimes=10
              if(k.gt.10)ntimes=ntimes+(k-9)
              norder=2
           else
              ntimes=ntimt
              norder=nordt
           endif
        do 540 nn=1,ntimes
#  if defined coast & defined coastedge
          call set_edges(xt(1,k,m),tgrid)
#  endif
          call shap_lev(xt(1,k,m),imt,jmtm1,tgrid,norder)
#  if defined coast & defined coastedge
          call set_edges(xt(1,k,m),tgrid)
#  endif
 540    continue
# endif
# if defined shapmean & defined pressbias
        call shap_mean(1)
# endif
 550    continue
      endif
# if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c
c  Check for negative tracers, print warning if found.
c
      if ((biopos.eq.3).or.(iopt(5).ne.0)) then 
         do 570 m=3,nt
            nnegtrc=0
            negtrc=c0
            postrc=c0
            do 560 k=1,km
            do 560 j=1,jmtm1
            do 560 i=1,imt
               ip=i+(j-1)*imt
               if(xt(ip,k,m).lt.c0) then
                  nnegtrc=nnegtrc+1
                  negtrc=negtrc+xt(ip,k,m)
               else
                  postrc=postrc+xt(ip,k,m)
               endif
 560        continue
            if (nnegtrc.gt.0) then 
               write(stdout,900)nnegtrc,m
               write(stdout,910)negtrc,postrc
               if(biopos.eq.3) call exitus('STEP')
            endif
 570     continue
      endif
c
c  Insure non-negative biological tracers.
c
      if(biopos.eq.1) then
        do 580 m=3,nt
        do 580 k=1,km
        do 580 j=1,jmtm1
        do 580 i=1,imt
          ip=i+(j-1)*imt
          xt(ip,k,m)=max(c0,xt(ip,k,m))
 580    continue
      endif
# endif
#endif
c
c  Put filtered data into disk.
c
#if !defined AsselinFilt & (defined shapiro | defined nest2larger | defined nest2smaller)
      call okeep(labs(ndiska))
#elif defined AsselinFilt
      call okeep(labs(ndiska),labs(ndisk ),labs(ndiskb))
#endif
c
c-----------------------------------------------------------------------
c  Write out line integral analysis.
c-----------------------------------------------------------------------
c
      if(prntsi.and.eots) then
        do 610 j=2,jmtm2
          do 590 k=km,1,-1
            ektot(0,1)=ektot(0,1)+ektot(k,j)
 590      continue
          do 600 m=1,nt
          do 600 k=km,1,-1
            dtabs(0,m,1)=dtabs(0,m,1)+dtabs(k,m,j)
 600      continue
 610    continue
        ektot(0,1)=ektot(0,1)/volume
        do 620 m=1,nt
          dtabs(0,m,1)=dtabs(0,m,1)/volume
 620    continue
        write(stdout,630) itt,ektot(0,1),dtabs(0,1,1),dtabs(0,2,1)
 630    format(1x,'TS = ',i7,2x,'KE = ',1pe13.6,2x,'Dtemp = ',1pe13.6,
     *         2x,'Dsalt = ',1pe13.6)
      endif
c
#if defined usrdiagnostic & defined nesttime
      call dtime (tmsc3)
#endif
#if (!defined nest2larger | !defined nest_ext2lrgr) & !defined bioadjloc
c-----------------------------------------------------------------------
c  Solve for the new stream function.
c-----------------------------------------------------------------------
c
      call relax
c
#endif
#if defined usrdiagnostic & defined nesttime
      call dtime (trlx)
c
#endif
#ifdef nest2smaller
c-----------------------------------------------------------------------
c  Send boundary conditions to smaller grid.
c-----------------------------------------------------------------------
c
# if !defined usrdiagnostic | !defined nesttime
      call nest_snd_bc (itt)
# else
      call nest_snd_bc (itt,tsn1,tsn2)
# endif
c
#endif
#if defined usrdiagnostic & defined nesttime
c-----------------------------------------------------------------------
c  Report other User dependent diagnostics.
c-----------------------------------------------------------------------
c
      call userdiag (itt,tcpg,tco,ttrm,ttsr,tlp,tmsc,tmsc2,tmsc3,trlx,
     &               tsn1,tsn2)
c
#endif
c-----------------------------------------------------------------------
c  If this is the end of the 1st pass of an euler backward timestep,
c  set the input disc units so that the proper levels are fetched on
c  the next pass.  The output for the 2nd pass will be placed on the
c  unused unit ("NDISKB") and transferred to the proper unit ("NDISKA")
c  later.  Return to the top of "STEP" to do the 2nd pass.
c-----------------------------------------------------------------------
c
      if(mixts.and.eb) then
        mix=0
        mxp=1
        eots=.true.
        mixts=.false.
        mxpas2=.true.
        ndiskx=ndiskb
        ndiskb=ndisk
        ndisk=ndiska
        ndiska=ndiskx
        go to 20
      endif
c
c-----------------------------------------------------------------------
c  If this is the end of the 2nd pass of an Euler backward timestep,
c  transfer the data written temporarily to "NDISKX" to its final
c  destination (the original "NDISKA").
c-----------------------------------------------------------------------
c
      if(mxpas2) then
        ndiska=ndisk
        ndisk=ndiskb
        do 640 j=2,jmtm1
          call oget(labs(ndiskx),nslab,(j-1)*nslab+1,ta)
          call oput(labs(ndiska),nslab,(j-1)*nslab+1,ta)
 640    continue
      endif
c
c-----------------------------------------------------------------------
c  For purposes of recovering from the disc after an abnormal stop,
c  normally inactive disc units are brought up to date here.
c-----------------------------------------------------------------------
c
      call oput(kflds,nwds,(ndiska-1)*nwds+1,p)
      call oput(kontrl,20,1,itt)
c
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
 900  format(/' WARNING - found negative biological tracer: ',i9, 
     *        ' instances, tracer ',i2)
 910  format(/' net negatives: ',1pe13.6,'  net positive: ',1pe13.6)
#endif
      return
      end
