      function tid_indx (comp,ncomp,compnam)
c
c=======================================================================
c                                                                    ===
c  This function determines the location of the specified tidal      ===
c  component in the given list.                                      ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     COMP      Tidal component to find in list.       (string)      ===
c     NCOMP     Number of activated tidal components.  (integer)     ===
c     COMPNAM   List of activated tidal components.    (string array)===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     TID_INDX   Location of component in list.   (integer)          ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ncomp
      integer     tid_indx
      character*2 comp
      character*2 compnam(ncomp)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      tid_indx = 1
c
      do 10 while ((comp.ne.compnam(tid_indx)).and.(tid_indx.lt.ncomp))
         tid_indx = tid_indx + 1
  10  continue
c
      if (comp.ne.compnam(tid_indx)) tid_indx=0
c
      return
      end
