      function tide_depth (d,i,j)
c
c=======================================================================
c                                                                    ===
c  This function returns the given depth if that depth is less than  ===
c  a critical value or a flag value (zero) otherwise.                ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     D            The test depth.             (real)                ===
c     I            I-index of test location.   (integer)             ===
c     J            J-index of test location.   (integer)             ===
c                                                                    ===
#if !defined posmxtid | ( defined mixtide & defined ext_tide )
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CVMIX/                                                           ===
c                                                                    ===
c     MTDDPTH   maximum water depth over which to apply              ===
c               tidal enhancing to vertical mixing.       (real; cm) ===
c                                                                    ===
#endif
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     TIDE_DEPTH   The given depth, if less than a critical          ===
c                  value. Zero, otherwise.                    (real) ===
c                                                                    ===
#if !defined posmxtid | ( defined mixtide & defined ext_tide )
c  Calls:  none                                                      ===
# else
c  Calls:  INITTDPTH                                                 ===
#endif
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
# include <cdefs.h>
# include <param.h>
# include <pconst.h>
# include <cvmix.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
#if defined posmxtid & ( !defined mixtide | !defined ext_tide )
      integer l,tdbox
      integer ine(tdboxmx),isw(tdboxmx),jne(tdboxmx),jsw(tdboxmx)
      logical first
      FLOAT
     &     depth(tdboxmx)
#endif
      integer i,j
      FLOAT
     &     d
      FLOAT
     &     tide_depth
c
#if defined posmxtid & ( !defined mixtide | !defined ext_tide )
      save depth,first,ine,isw,jne,jsw,tdbox
      data first /.true./
c
#endif
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#if !defined posmxtid | ( defined mixtide & defined ext_tide )
c-----------------------------------------------------------------------
c  Flag tidally active depths over entire domain.
c-----------------------------------------------------------------------
c
      if (d.lt.mtddpth) then
         tide_depth = d
       else
         tide_depth = c0
      endif
# else
c-----------------------------------------------------------------------
c  Flag tidally active depths over pre-defined regions.
c-----------------------------------------------------------------------
c
c  On first call, read region-defining data.
c
      if (first) then
         call inittdpth (tdboxmx,tdbox,isw,ine,jsw,jne,depth)
         first = .false.
      end if
c
c  Flag depths.
c
      tide_depth=c0
c
      do 10 l=1,tdbox
         if ( (i.ge.isw(l)) .and. (i.le.ine(l)) .and.(j.ge.jsw(l)) 
     &        .and. (j.le.jne(l)) .and. (d.lt.depth(l)) ) then
            tide_depth = d
         endif
  10  continue
#endif
c
      return
      end
