      function tide_val (Kvm,dbot,d,i,k)
c
c=======================================================================
c                                                                    ===
c  This function returns a vertical mixing coefficient based on the  ===
c  tidal velocity.                                                   ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     KVM        Maximum mixing coefficient.       (real; cm^2/s)    ===
c     DBOT       Total depth of water column.      (real; cm)        ===
c     D          Depth at bottom of current box.   (real; cm)        ===
c     I          Current x-location.               (integer)         ===
c     K          Current level.                    (integer)         ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CVMIX/                                                           ===
c                                                                    ===
#if defined ext_tide & defined mixtide
c     CDTID    tidal friction coefficient.          (real; s)        ===
c     TDMXFRC  tidal mixing limit.                  (real; cm^2/s)   ===
# elif defined posmxtid
c     TDMXFAC  constant tidal mixing coefficient.   (real; cm^2/s)   ===
#endif
c                                                                    ===
#if defined ext_tide & defined mixtide
c  /TIDESP/                                                          ===
c                                                                    ===
c     UTIDE    zonal component of tidal velocity.        (real; cm/s)===
c     VTIDE    meridional component of tidal velocity.   (real; cm/s)===
c                                                                    ===
#endif
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     TIDE_VAL   Tidal mixing coefficient.         (real; cm^2/s)    ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <cvmix.h>
#if defined ext_tide & defined mixtide
# include <tidesp.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,k
      FLOAT
     *     d,dbot,Kvm
#if defined ext_tide & defined mixtide
     *     ,tdfrc
#endif
      FLOAT
     *     tide_val
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#if defined ext_tide & defined mixtide
c-----------------------------------------------------------------------
c  Compute tidal mixing coefficient based on tidal velocities.
c-----------------------------------------------------------------------
c
      tdfrc = cdtid*(utide(i,k)*utide(i,k)+vtide(i,k)*vtide(i,k))
c
      if (dbot.gt.c0) then
         tide_val = min( tdfrc, tdmxfrc )
       else
         tide_val = c0
      endif
c
# elif defined posmxtid
c-----------------------------------------------------------------------
c  Apply constant tidal mixing coefficient in pre-defined regions.
c-----------------------------------------------------------------------
c
      if (dbot.gt.c0) then
         tide_val = tdmxfac
       else
         tide_val = c0
      endif
c
#endif
      return
      end
