c
c=======================================================================
c  Include file "tidesp.h"
c=======================================================================
c
#ifndef rmdocinc
c  FUWTD    tidal flux through western wall.
c  FVNTD    tidal flux through northern wall.
c  FVSTDU   tidal flux through southern wall of velocity boxes.
c  FVSTDT   tidal flux through southern wall of tracer boxes.
c  SADV     scaling factor on tidal advection.
c  SRFTD    tidal elevation, present time step.
c  BTIDE    square of bottom tidal velocities, row J, present time step.
c  BTIDEP   square of bottom tidal velocities, row J+1, present time step.
c  UTIDE    zonal component of tidal velocity, row J, present timestep.
c  UTIDEM   zonal component of tidal velocity, row J-1, present timestep.
c  UTIDEP   zonal component of tidal velocity, row J+1, present timestep.
c  VTIDE    meridional component of tidal velocity, row J, present timestep.
c  VTIDEM   meridional component of tidal velocity, row J-1, present timestep.
c  VTIDEP   meridional component of tidal velocity, row J+1, present timestep.
# ifdef tide_zero
c  TUUX     residual tidal stress uux
c  TVUY     residual tidal stress vuy
c  TWUZ     residual tidal stress wuz
c  TUVX     residual tidal stress uvx
c  TVVY     residual tidal stress vvy
c  TWVZ     residual tidal stress wvz
# endif
c
c=======================================================================
c
#endif
      common /tidesp/ srftd,btide,btidep,
     *                utide,vtide,utidem,vtidem,utidep,vtidep
     *                ,fuwtd,fvntd,fvstdu,fvstdt
#ifdef tide_zero
     *                ,tuux,tvuy,twuz,tuvx,tvvy,twvz
#endif
#ifdef advtide0
     *      ,sadv
#endif
      FLOAT 
     *      srftd (imt,jmt),
     *      utide (imt,km),vtide (imt,km),
     *      utidem(imt,km),vtidem(imt,km),
     *      btide (imt),btidep(imt),
     *      utidep(imt,km),vtidep(imt,km)
     *      ,fuwtd (imt,km),fvntd(imt,km),fvstdu(imt,km),fvstdt(imt,km)
#ifdef tide_zero
     *      ,tuux(imt,km),tvuy(imt,km),twuz(imt,km)
     *      ,tuvx(imt,km),tvvy(imt,km),twvz(imt,km)
#endif
#ifdef advtide0
     *      ,sadv
#endif
