      function trackbound(track)
c
c=======================================================================
c                                                                    ===
c  This function determines whether  or not the given Lagrangian     ===
c  drifter has drifted out of bounds. TRACKBOUND returns a three     ===
c  (3) if the drifter is out of bounds and a one (1) otherwise.      ===
c                                                                    ===
c     On Input:                                                      ===
c                                                                    ===
c     TRACK  descriptor of the drifter (real array)                  ===
c            TRACK(1) -- grid X coordinate of drifter location       ===
c            TRACK(2) -- grid Y coordinate of drifter location       ===
c                                                                    ===
c     Calls:    none                                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer trackbound
      FLOAT
#ifndef cyclic
     *      xhi,xlo,xu,
#endif
     *      yhi,ylo,yu
      FLOAT
     *      track(8)
c
c-----------------------------------------------------------------------
c Begin executable code.
c-----------------------------------------------------------------------
c
#ifndef cyclic
      xlo=c1
      xhi=FLoaT(imtm1)
      xu=track(1)-p5
#endif
      ylo=c1
      yhi=FLoaT(jmtm1)
      yu=track(2)-p5
#ifndef cyclic
      if((xu.lt.xlo).or.(yu.lt.ylo).or.(xu.gt.xhi).or.(yu.gt.yhi)) then
# else
      if((yu.lt.ylo).or.(yu.gt.yhi)) then
#endif
        trackbound=3
      else
        trackbound=1
      endif
      return
      end
