      subroutine trackinit
c
c=======================================================================
c                                                                    ===
c  This routine initializes the Lagrangian drifters.                 ===
c                                                                    ===
c     Calls:  none                                                   ===
c                                                                    ===
c     Common blocks:   (only relevant variables documented)          ===
c                                                                    ===
c     /MODDAT/                                                       ===
c                                                                    ===
c     COORD    flag for type of horizontal coordinates.  (input)     ===
c              [0] cartesian [1] spherical [2] rotated spherical     ===
c     GRIDX    grid spacing in the x-direction (cm or degrees; input)===
c     GRIDY    grid spacing in the y-direction (cm or degrees; input)===
c                                                                    ===
c     /SCALAR/                                                       ===
c                                                                    ===
c     DTUV     model velocity time step (sec; input; real)           ===
c                                                                    ===
c     /TRACKTIME/                                                    ===
c                                                                    ===
c     NSTEP    number of tracer time steps per model time step       ===
c              (integer; output)                                     ===
c     DTSTEP   size of tracer time step (days; real; output)         ===
c                                                                    ===
c     /TRKSCL/                                                       ===
c                                                                    ===
c     FACTT    time scale (sec; real; output)                        ===
c     FACTX    x-horizontal space scale (cm; real; output)           ===
c     FACTY    y-horizontal space scale (cm; real; output)           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <scalar.h>
#include <moddat.h>
#include <trkscl.h>
#include <tracktime.h>
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  Determine track scaling factors.
c  ***NOTE: this version assumes equally spaced grid points.
c-----------------------------------------------------------------------
c
      if(coord.eq.0) then
        factx=gridx
        facty=gridy
       else
        factx=gridx*deg2rad*re
        facty=gridy*deg2rad*re
      endif
      factt=dtuv
c
c-----------------------------------------------------------------------
c  Set track time stepping factors.
c-----------------------------------------------------------------------
c
      nstep=1
      dtstep=dtuv/FLoaT(nstep)*sec2day
      return
      end
