      subroutine trackrefresh
c
c=======================================================================
c                                                                    ===
c  This loads the final slab into the volume density array.          ===
c                                                                    ===
c   Common Blocks:       (only relevant variables documented.        ===
c                                                                    ===
c     /FULLWD/                                                       ===
c                                                                    ===
c     LABS       rolling disk unit numbers for the virtual disk      ===
c                data (integer array; input)                         ===
c     NDISK      index for the unit number for current data          ===
c                (integer; input)                                    ===
c                                                                    ===
c     /TRKFLD/                                                       ===
c                                                                    ===
c     SIG_VOL    the density at the current time (real array; output)===
c                                                                    ===
c     /VERTSLAB/                                                     ===
c                                                                    ===
c     JRN        pointer to north slab  (integer; input)             ===
c     TDEPTH     depths at tracer points in needed slabs  (real      ===
c                array; input)                                       ===
c                                                                    ===
c     Note:  The arrays T & RHON in the common block /WORKSP/ are    ===
c            used as work space.                                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <fullwd.h>
#include <trkfld.h>
#include <vertslabs.h>
#include <workspa.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,imtkm2,k
      parameter (imtkm2=imtkm*2)
c
c-----------------------------------------------------------------------
c Begin executable code.
c-----------------------------------------------------------------------
c
      call opick(labs(ndisk),nslab,jmtm1*nslab+1,1,imtkm2,t)
      call state(t(1,1,1),t(1,1,2),tdepth(1,1,jrn),rhon)
      do 10 k=1,km
        do 10 i=1,imt
          sig_vol(i,jmt,k)=rhon(i,k)
 10   continue
      return
      end
