c
c=======================================================================
c  Include file "tracks.h"
c=======================================================================
c
#ifndef rmdocinc
c  IDENT        drifter identifier.
c  LENID        number of character in drifter identifier.
c  MAXFLOATS    maximum number of drifters allowed/allocated.
c  NFLOATS      number of drifters to simulate.
c  STATUS       trajectory computation status.
c  TRACK        descriptor of the N-drifter:
c               TRACK(1,n):  x-position.
c               TRACK(2,n):  y-position.
c               TRACK(3,n):  z-position: depth.
c               TRACK(4,n):  time after model initialization.
c               TRACK(5,n):  u-component velocity.
c               TRACK(6,n):  v-component velocity.
c               TRACK(7,n):  vertical velocity.
c               TRACK(8,n):  density or drifter extent.
c  TSTART       release time of the N-drifter:
c               TSTART(1,n): modified Julian day.
c               TSTART(2,n): days since initialization.
c  TYPE         pointer for drifter type: surface or density floats.
c  
c=======================================================================
c
#endif
      integer lenid,maxfloats
      parameter(lenid=40,maxfloats=1000)
c
      common /itracks/ nfloats,status
      integer nfloats,status(maxfloats)
c
      common /ftracks/ track,tstart
      FLOAT
     *      track(8,maxfloats),tstart(2,maxfloats)
c
      common /ctracks/ type,ident
      character*1  type(maxfloats)
      character*40 ident(maxfloats)

