      subroutine trackstep
c
c=======================================================================
c                                                                    ===
c  This routine performs the integration of the velocity to obtain   ===
c  the Lagrangian trajectories.                                      ===
c                                                                    ===
c     Calls:      FSIGMA, RK40, SIGMA2Z, TRKVSCL                     ===
c                                                                    ===
c     Common blocks:                                                 ===
c                                                                    ===
c     /TRACKS/                                                       ===
c                                                                    ===
c     TRACK    descriptor of the drifter (real array; input)         ===
c     TSTART   release time (real array; input)                      ===
c     STATUS   trajectory status (integer array; input)              ===
c     NFLOATS  number of simulated drifters (integer; input)         ===
c                                                                    ===
c     /TRACKSC/                                                      ===
c                                                                    ===
c     TYPE     pointer for drifter type: surface or density floats   ===
c              (character array; input)                              ===
c     IDENT    drifter indentifier (character array; input)          ===
c                                                                    ===
c     /TRACKTIME/                                                    ===
c                                                                    ===
c     ISTEP    interval of integration (integer; output)             ===
c     NSTEP    number of time integration steps per model timestep   ===
c              (integer; input)                                      ===
c     IWUP     pointer to compute vertical velocity (integer;        ===
c              output)                                               ===
c     DTSEP    integration time step (days; real; input)             ===
c                                                                    ===
c     /TRKSCL/                                                       ===
c                                                                    ===
c     DTYP     Drifter type.                           (character)   ===
c     HD       Diameter (height) of extended drifter.  (real; cm)    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
#include <tracks.h>
#include <tracktime.h>
#include <trkscl.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer itr,trackup,trackbound
      FLOAT
     *      h,torig
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      do 20 itr=1,nfloats
        if(status(itr).eq.0) then
          status(itr)=trackup(tstart(2,itr))
          if((status(itr).eq.1).and.(type(itr).eq.'s'))
     *      call fsigma(track(1,itr))
        endif
        if(status(itr).eq.1) then
          if(type(itr).eq.'s') then
            iwup=1
          else
            iwup=0
          endif
          if(type(itr).eq.'x') hd=track(8,itr)
          dtyp = type(itr)
          do 10 istep=1,nstep
            torig=FLoaT(istep-1)/FLoaT(nstep)
            h=c1/FLoaT(nstep)
            call rk40(track(1,itr),torig,h,track(1,itr))
            track(4,itr)=track(4,itr)+dtstep
            call trkvscl(track(1,itr))
            if (type(itr).eq.'s') then
              call sigma2z(track(1,itr))
            elseif (type(itr).eq.'z') then
              track(8,itr)=c0
            endif
            status(itr)=trackbound(track(1,itr))
  10      continue
        endif
  20  continue
      return
      end
