      function trackup(tstart)
c
c=======================================================================
c                                                                    ===
c  This function signals when the given Lagrangian drifter should    ===
c  be started. TRACKUP returns a one (1) if the starting time has    ===
c  been reached and a zero (0) otherwise.                            ===
c                                                                    ===
c     On Input:                                                      ===
c                                                                    ===
c            TSTART      starting time of drifter (model clock)      ===
c                                                                    ===
c     Calls:  none                                                   ===
c                                                                    ===
c     Common blocks: (only relevant variables documented)            ===
c                                                                    ===
c     /FULLWD/                                                       ===
c                                                                    ===
c     TTSEC   total elapsed time of model run (at advanced time)     ===
c             (sec; real; input)                                     ===
c                                                                    ===
c     /SCALAR/                                                       ===
c                                                                    ===
c     DTTS    relevant time step for TTSEC (sec; real; input)        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fullwd.h>
#include <scalar.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer trackup
      FLOAT
     *      tstart
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      if(tstart.le.(ttsec-p5*dtts)*sec2day) then
        trackup=1
      else
        trackup=0
      endif
      return
      end
