      subroutine trkvscl (track)
c
c=======================================================================
c                                                                    ===
c  This routine rescales the velocities to cm/s.                     ===
c                                                                    ===
c     Calls:      BES1D                                              ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     TRACK   descriptor to the drifter.  (real array)               ===
c             TRACK(2)   -- y position of drifter.                   ===
c             TRACK(5:7) -- velocity components (1/day)              ===
c                                                                    ===
c     Common Blocks:                                                 ===
c                                                                    ===
c     /ONEDIM/                                                       ===
c                                                                    ===
c     CS      cosine metric factors.                                 ===
c                                                                    ===
c     /TRKSCL/                                                       ===
c                                                                    ===
c     FACTT   time scale  (sec).                                     ===
c     FACTX   x-horizontal space scale (cm).                         ===
c     FACTY   y-horizontal space scale (cm).                         ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     TRACK   descriptor to the drifter.  (real array)               ===
c             TRACK(5:7) -- velocity components (cm/s)               ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
#include <param.h>
#include <onedim.h>
#include <trkscl.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer jbry,jy,jym,jyp,jyp2
      logical first
      FLOAT
     *      bes1d,track(7),ujscl,uscale,vscale,wscale,y,ymax,ymjy
c
      save first,uscale,vscale,wscale,ymax
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  On first call, set basic velocity scales.
c-----------------------------------------------------------------------
c
      if(first) then
        uscale=factx/factt
        vscale=facty/factt
        wscale=p5*(factx+facty)/factt
        ymax=FLoaT(jmt-2)
        first=.false.
      endif
c
c-----------------------------------------------------------------------
c  Rescale the drifter velocity.
c-----------------------------------------------------------------------
c
      y=track(2)
      jy=int(y)
      if((y.gt.c1).and.(jy.lt.jmtm1)) then
        ymjy=track(2)-FLoaT(jy)
        jym=max(min(jy-1,jmtm1),1)
        jyp=max(min(jy+1,jmtm1),1)
        jyp2=max(min(jy+2,jmtm1),1)
        jbry=0
        if(y.lt.c2) then
          jbry=1
        elseif(y.ge.ymax) then
          jbry=2
        endif
        ujscl=bes1d(ymjy,cs(jym),cs(jy),cs(jyp),cs(jyp2),jbry)*uscale
      elseif(y.le.c1) then
        ujscl=cs(1)*uscale
      else
        ujscl=cs(jmtm1)*uscale
      endif
c
      track(5)=track(5)*ujscl
      track(6)=track(6)*vscale
      track(7)=track(7)*wscale
c
      return
      end
