#ifndef nesttime
      subroutine userdiag (j)
# else
      subroutine userdiag (ittdum,tcpg,tco,ttrm,ttsr,tlp,tmsc,tmsc2,
     &                     tmsc3,trlx,tsn1,tsn2)
#endif
c
c=======================================================================
c                                                                    ===
c  This is provided for user specific diagnostics.                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <iounits.h>
#include <workspa.h>
#include <fullwd.h>
#ifdef nesttime
# include <runid.h>
# include <scalar.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
#ifndef nesttime
      integer i,imx,j,jmx,k,kmx
      FLOAT
     *      umax,val
# else
      integer i,ittdum
      logical first,ok
      FLOAT
     &      tcpg(2),tco(2),ttrm(2),ttsr(2),tlp(2),tmsc(2),tmsc2(2),
     &      tmsc3(2),trlx(2),tsn1(2),tsn2(2)
c
      data first,ok /.true.,.true./
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifndef nesttime
c-----------------------------------------------------------------------
c  Initialize pointers & values.
c-----------------------------------------------------------------------
c
      if (j.eq.2) then
         imx = 0
         jmx = 0
         kmx = 0
         umax = c0
      end if
c
c-----------------------------------------------------------------------
c  Find maximum velocity and its location.
c-----------------------------------------------------------------------
c
      do 10 k = 1, km
      do 10 i = 1, imtm1
c
         val =  sqrt( u(i,k)*u(i,k) + v(i,k)*v(i,k) )
         if ( (val.ge.umax) .and. (gm(i,k).eq.1) ) then
            imx = i
            jmx = j
            kmx = k
            umax = val
         end if
c
         if (j .eq. 2) then
c
            val =  sqrt( um(i,k)*um(i,k) + vm(i,k)*vm(i,k) )
            if ( (val.ge.umax) .and. (gm(i,k).eq.1) ) then
               imx = i
               jmx = 1
               kmx = k
               umax = val
            end if
c
         end if
c
         if (j .eq. jmtm2) then
c
            val =  sqrt( up(i,k)*up(i,k) + vp(i,k)*vp(i,k) )
            if ( (val.ge.umax) .and. (gm(i,k).eq.1) ) then
               imx = i
               jmx = jmtm1
               kmx = k
               umax = val
            end if
c
         end if
c
  10  continue
c
c-----------------------------------------------------------------------
c  Report results.
c-----------------------------------------------------------------------
c
      if (j.eq.jmtm2) then
         write(stdout,20) ttsec*sec2day,umax,imx,jmx,kmx
#  ifdef sunflush
         call flush(stdout)
#  endif
      end if
#else
c-----------------------------------------------------------------------
c  Open output file.
c-----------------------------------------------------------------------
c
      if (first) then
         call file_chk (usrname,'Timing Diagnostic Output File',
     &                  'Output',ok)
         if (.not.ok) call exitus ('USERDIAG')
         open (usrinp, file=usrname, status='unknown')
         write (usrinp,'(20a4)') (titlrun(i),i=1,20)
         write (usrinp,'(1pg15.8)') dtts
         first = .false.
      end if
c
c-----------------------------------------------------------------------
c  Write timings for current time step.
c-----------------------------------------------------------------------
c
      write (usrinp,10) itt,tcpg(1),tcpg(2),tco(1),tco(2),ttrm(1),
     &                  ttrm(2),ttsr(1),ttsr(2),tlp(1),tlp(2),trlx(1),
     &                  trlx(2),tsn1(1),tsn1(2),tsn2(1),tsn2(2),
     &                  (tmsc(1)+tmsc2(1)+tmsc3(1)),
     &                  (tmsc(2)+tmsc2(2)+tmsc3(2))
#endif
c
      return
c
#ifndef nesttime
  20  format ('MAXVEL:  t=',1pg10.3,' max(u)=',1pg10.3,' (i,j,k)=(',i4,
     *        ',',i4,',',i4,')')
# else
  10  format (i8,18(1x,1pe8.2))
#endif
c
      end
