      function vbar_test (ptd,first)
c
c=======================================================================
c                                                                    ===
c  This function computes the relative change in the barotropic      ===
c  velocity and reports the maximum value.                           ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     ptd.........The change in the transport streamfunction.        ===
c     first.......Flag indicating the value to compute.              ===
c                 [.true.]   reset working storage.                  ===
c                 [.false.]  compute change in barotropic velocities.===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /FIELDS/                                                          ===
c                                                                    ===
c     HV    reciprocal depth over velocity points.                   ===
c                                                                    ===
#ifdef coast
c  /FIELDS/                                                          ===
c                                                                    ===
c     LANDV      land/sea mask at velocity points.                   ===
c                                                                    ===
#endif
c  /ONEDIM/                                                          ===
c                                                                    ===
c     CSR      reciprocal of CS (CSR=1/CS).                          ===
c     DXU2R    reciprocal of twice DXU (DXU2R=0.5/DXU).              ===
c     DYU2R    reciprocal of twice DYU (DYU2R=0.5/DYU).              ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     vbar_test...Maximum relative change in barotropic velocities.  ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global variables.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fields.h>
#include <onedim.h>
#ifdef coast
#  include <fullwd.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local variables.
c-----------------------------------------------------------------------
c
      integer i,j,k,new,old
      logical first
      FLOAT
     &     diag1,diag2,utst,vtst
      FLOAT
     &     ptd(imt,jmt),ubtst(imtm1,jmtm1,0:1),vbtst(imtm1,jmtm1,0:1)
      FLOAT
     &     vbar_test
c
      save new,old,ubtst,vbtst
c
c=======================================================================
c  Begin executable code
c=======================================================================
c
      if (first) then
c
c-----------------------------------------------------------------------
c  On first call of a time step, reset working storage.
c-----------------------------------------------------------------------
c
         do 10 k = 0, 1
         do 10 j = 1, jmtm1
         do 10 i = 1, imtm1
            ubtst(i,j,k) = c0
            vbtst(i,j,k) = c0
 10      continue
c
         new       = 0
         old       = 1
         vbar_test = c1
c
        else
c
c-----------------------------------------------------------------------
c  On subsequent calls, compute relative change in barotropic velocity
c  tendency.
c-----------------------------------------------------------------------
c
         new       = 1 - new
         old       = 1 - old
         vbar_test = c0
c
         do 20 j = 1, jmtm1
         do 20 i = 1, imtm1
#ifdef coast
            if (landv(i,j).ne.0) then
#endif
               diag1=ptd(i+1,j+1)-ptd(i  ,j)
               diag2=ptd(i  ,j+1)-ptd(i+1,j)
               ubtst(i,j,new) = -(diag1+diag2)*dyu2r(j)*hv(i,j)
               vbtst(i,j,new) =  (diag1-diag2)*dxu2r(i)*hv(i,j)*csr(j)
               utst = abs(ubtst(i,j,new)-ubtst(i,j,old)) / max( c1,
     &                p5*abs(ubtst(i,j,new)+ubtst(i,j,old)) )
               vtst = abs(vbtst(i,j,new)-vbtst(i,j,old)) / max( c1,
     &                p5*abs(vbtst(i,j,new)+vbtst(i,j,old)) )
               vbar_test = max( vbar_test, utst, vtst )
#ifdef coast
            end if
#endif
 20      continue
c
      end if
c
      return
      end
