c
c=======================================================================
c  Include file "vertslabs.h"
c=======================================================================
c
#ifndef rmdocinc
# ifdef analytical
c  BTDEPTH    depth of the middle of the tracer vertical box at the
c             domain boundary.
c  BVDEPTH    depth of the middle of the velocity vertical box at the
c             domain boundary.
# endif
c  DZQZ       vertical thickness of the tracer box.
c  DZ2RQZ     reciprocal of 2 times DZQZ.
c  DZVQZ      vertical thickness of the velocity box.
c  DZV2RQZ    reciprocal of 2 times DZVQZ.
c  DZZQZ      vertical grid spacing between tracer points.
c  DZZ2RQZ    reciprocal of 2 times DZZQZ.
c  DZZVQZ     vertical grid spacing between velocity points.
c  HD         bottom topography at the tracer points.
c  HDV        bottom topography at the velocity points.
c  HVAV       reciprocal of total thickness at the velocity points.
c  JRN        rolling index for the north face of the T,U,V box.
c  JRNP1      rolling index for the row above the north face of the
c             T,U,V box.
c  IORD       order of horizontal operators (second or forth order).
c  JRS        rolling index for the south face of the T,U,V box
c  JRSM1      rolling index for the row below the south face of the
c             T,U,V box.
c  TDEPTH     depth at the center of the tracer vertical box.
c  VDEPTH     depth at the center of the velocity vertical box.
#if defined ext_tide & defined advtide
c  USTRETCH   stretch factor of vertical at  u-points.
c  TSTRETCH   stretch factor of vertical at  t-points.
#endif
c
c  The third dimension in arrays TDEPTH and VDEPTH corresponds to
c  the following indices according to the horizontal operator used:
c
c    Index       Tracer box       Velocity box      Order
c
c    JRNP1        J+2 slab          J+1 slab       4th only
c    JRN          J+1 slab          J   slab       2nd & 4th
c    JRS          J   slab          J-1 slab       2nd & 4th
c    JRSM1        J-1 slab          J-2 slab       4th only
c
c  The third dimension in the vertical grid spacing and thicknesses
c  arrays corresponds to the following slabs:
c
c    Index       Tracer box       Velocity box
c
c     0           J   slab          J   slab
c     1           J+1 slab          J-1 slab
c
c=======================================================================
c
#endif
      integer iord,iordm1
#if defined hpg4 | !defined shapiro
      parameter (iord=4,iordm1=iord-1)
#else
      parameter (iord=2,iordm1=iord-1)
#endif
#ifndef analytical
      common /ivertslab/ jrsm1,jrs,jrn,jrnp1
      integer jrn,jrnp1,jrs,jrsm1
c
      common /fvertslab/ hd,hdv,hvav,dzqz,dz2rqz,dzvqz,
     *       dzv2rqz,dzzqz,dzz2rqz,dzzvqz,tdepth,vdepth
# if defined ext_tide & defined advtide
     *       ,ustretch,tstretch
# endif
      FLOAT 
     *      dzqz(imt,km,0:1),dz2rqz(imt,km,0:1),dzvqz(imt,km,0:1),
     *      dzv2rqz(imt,km),dzzqz(imt,kmp1,0:1),dzz2rqz (imt,km,0:1),
     *      dzzvqz(imt,kmp1,0:1),hd(imt,jmt),hdv(imt,jmt),hvav(imt,jmt),
     *      tdepth(imt,km,0:iordm1),vdepth(imt,km,0:iordm1)
# if defined ext_tide & defined advtide
     *       ,ustretch(imt,jmt),tstretch(imt,jmt)
# endif
#else
      common /ivertslab/ jrsm1,jrs,jrn,jrnp1
      integer jrn,jrnp1,jrs,jrsm1
c
      common /fvertslab/ hd,hdv,hvav,dzqz,dz2rqz,dzvqz,
     *       dzv2rqz,dzzqz,dzz2rqz,dzzvqz,tdepth,vdepth,btdepth,
     *       bvdepth
# if defined ext_tide & defined advtide
     *       ,ustretch,tstretch
# endif
      FLOAT 
     *      dzqz(imt,km,0:1),dz2rqz(imt,km,0:1),dzvqz(imt,km,0:1),
     *      dzv2rqz(imt,km),dzzqz(imt,kmp1,0:1),dzz2rqz (imt,km,0:1),
     *      dzzvqz(imt,kmp1,0:1),hd(imt,jmt),hdv(imt,jmt),hvav(imt,jmt),
     *      tdepth(imt,km,0:iordm1),vdepth(imt,km,0:iordm1),
     *      btdepth(ijmx,km,4),bvdepth(ijmx,km,4)
# if defined ext_tide & defined advtide
     *       ,ustretch(imt,jmt),tstretch(imt,jmt)
# endif
#endif
