      subroutine vntrpv (ipt,jpt,z,u,ub,v,vb,uz,uzb,vz,vzb)
c
c=======================================================================
c                                                                    ===
c  This routine performs Vertical Interpolation of horizontal        ===
c  Velocity.                                                         ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IPT   X-index of desired point.                    (integer)   ===
c     JPT   Y-index of desired point.                    (integer)   ===
c     Z     Desired depth of interpolation.              (real)      ===
c     U     Internal zonal velocities, current.          (real array)===
c     UB    Internal zonal velocities, previous.         (real array)===
c     V     Internal meridional velocities, current.     (real array)===
c     VB    Internal meridional velocities, previous.    (real array)===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     UZ    Interpolated zonal velocity, current.        (real)      ===
c     UZB   Interpolated zonal velocity, previous.       (real)      ===
c     VZ    Interpolated meridional velocity, current.   (real)      ===
c     VZB   Interpolated meridional velocity, previous.  (real)      ===
c                                                                    ===
c  Calls:  BRACKET_Z                                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ipt,jpt,levdn,levup
      FLOAT
     *      dzd,dzu,uz,uzb,vz,vzb,z,zdn,zup
      FLOAT
     *      u(imt,km),ub(imt,km),v(imt,km),vb(imt,km)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Determine interpolation levels & weights.
c-----------------------------------------------------------------------
c
      call bracket_z (ipt,jpt,z,vgrid,levup,levdn,dzu,dzd,zup,zdn)
c
c-----------------------------------------------------------------------
c  Interpolate internal mode horizontal velocities.
c-----------------------------------------------------------------------
c
      uz  = u (ipt,levup)*dzu + u (ipt,levdn)*dzd
      uzb = ub(ipt,levup)*dzu + ub(ipt,levdn)*dzd
      vz  = v (ipt,levup)*dzu + v (ipt,levdn)*dzd
      vzb = vb(ipt,levup)*dzu + vb(ipt,levdn)*dzd
c
      return
      end
