c
c=======================================================================
c  Include file "workspa.h"
c=======================================================================
c
#ifndef rmdocinc
c  BCON   slab incidental data on N+1 slab.
c  DXT4RQ reciprocal of four times DXTQ, vectorization array.
c  DXTQ   zonal grid spacing across tracer boxes, vectorized.
c  DXU2RQ reciprocal of twice DXUQ, vectorization array.
c  DXUQ   zonal grid spacing across velocity boxes, vectorized.
c  DZTLRQ lower vertical diffusion grid factor a tracer points.
c  DZTURQ upper vertical diffusion grid factor a tracer points.
c  DZVLRQ lower vertical diffusion grid factor a velocity points.
c  DZVURQ upper vertical diffusion grid factor a velocity points.
c  FKMT   number of vertical levels of ocean at tracer points, row J.
c  FKMTM  number of vertical levels of ocean at tracer points, row J-1.
c  FKMTP  number of vertical levels of ocean at tracer points, row J+1.
c  FKMU   number of vertical levels of ocean at velocity points, row J.
c  FKMUM  number of vertical levels of ocean at velocity points, row J-1.
c  FKMUP  number of vertical levels of ocean at velocity points, row J+1.
c  FM     masking array for tracer points, row J.
c  FMM    masking array for tracer points, row J-1.
c  FMP    masking array for tracer points, row J+1.
c  FUW    advective coefficient for west face of computation box.
c  FVN    advective coefficient for north face of computation box.
c  FVST   advective coefficient for south face of tracer box.
c  FVSU   advective coefficient for south face of velocity box.
c  GM     masking array for velocity points, row J.
c  RHON   density for the row to the north.
c  RHOS   density for the row to the south.
c  T      tracer type variables, row J, present timestep.
c  TA     tracer type variables, row J, next timestep.
c  TB     tracer type variables, row J, previous timestep.
c  TBM    tracer type variables, row J-1, previous timestep.
c  TBP    tracer type variables, row J+1, previous timestep.
# ifdef bndy_rlx
c  Tbrlx  tracer boundary relaxation source terms, row J, present timestep.
# endif
c  TEMPA  utility array used as temporary storage.
c  TEMPB  utility array used as temporary storage.
c  TM     tracer type variables, row J-1, present timestep.
c  TP     tracer type variables, row J+1, present timestep.
c  Tsrc   tracers source/sink term.
c  Txx    zonal diffusion of tracers.
c  Tyy    meridional diffusion of tracers.
c  Tzz    vertical diffusion of tracers.
c  U      zonal component of velocity, row J, present timestep.
c  UA     zonal component of velocity, row J, next timestep.
c  UB     zonal component of velocity, row J, previous timestep.
c  UBM    zonal component of velocity, row J-1, previous timestep.
c  UBP    zonal component of velocity, row J+1, previous timestep.
# if defined bndy_rlx | defined cstfrc | defined botfrc
c  Ubrlx  zonal velocity boundary relaxation forcing, row J, present timestep.
# endif
c  UCL    internal mode zonal velocity, row J, present timestep.
c  UCLB   internal mode zonal velocity, row J, previous timestep.
c  UCLBP  internal mode zonal velocity, row J+1, previous timestep.
c  UCLM   internal mode zonal velocity, row J-1, present timestep.
c  UCLP   internal mode zonal velocity, row J+1, present timestep.
c  UM     zonal component of velocity, row J-1, present timestep.
c  Umet   metric terms for zonal velocity laplacian
c  UP     zonal component of velocity, row J+1, present timestep.
c  UTx    zonal advection of tracers.
c  UUx    zonal advection of zonal momentum.
c  UVx    zonal advection of meridional momentum.
c  Uxx    zonal diffusion of zonal momentum.
c  Uyy    meridional diffusion of zonal momentum.
c  Uzz    vertical diffusion of zonal momentum.
c  V      meridional component of velocity, row J, present timestep.
c  VA     meridional component of velocity, row J, next timestep.
c  VB     meridional component of velocity, row J, previous timestep.
c  VBM    meridional component of velocity, row J-1, previous timestep.
c  VBP    meridional component of velocity, row J+1, previous timestep.
# if defined bndy_rlx | defined cstfrc | defined botfrc
c  Vbrlx  meridional velocity bndy relaxation forcing, row J, present timestep.
# endif
c  VCL    internal mode meridional velocity, row J, present timestep.
c  VCLB   internal mode meridional velocity, row J, previous timestep.
c  VCLBP  internal mode meridional velocity, row J+1, previous timestep.
c  VCLM   internal mode meridional velocity, row J-1, present timestep.
c  VCLP   internal mode meridional velocity, row J+1, present timestep.
c  VM     meridional component of velocity, row J-1, present timestep.
c  Vmet   metric terms for meridional velocity laplacian
c  VMF    utility array for vertical momentum flux.
c  VP     meridional component of velocity, row J+1, present timestep.
c  VTF    utility array for vertical tracer flux.
c  VTy    meridional advection of tracers.
c  VUy    meridional advection of zonal momentum.
c  VVy    meridional advection of meridional momentum.
c  Vxx    zonal diffusion of meridional momentum.
c  Vyy    meridional diffusion of meridional momentum.
c  Vzz    vertical diffusion of meridional momentum.
c  W      terrain-following "omega" vertical velocity at tracer points.
c  WSX    zonal component of surface wind stress, row J.
c  WSXM   zonal component of surface wind stress, row J-1.
c  WSXP   zonal component of surface wind stress, row J+1.
c  WSY    meridional component of surface wind stress, row J.
c  WSYM   meridional component of surface wind stress, row J-1.
c  WSYP   meridional component of surface wind stress, row J+1.
c  WTz    vertical advection of tracers.
c  WU     terrain-following "omega" vertical velocity at velocity points.
c  WUz    vertical advection of zonal momentum.
c  WVELT  flat "true" vertical velocity at tracer points.
c  WVELU  flat "true" vertical velocity at velocity points.
c  WVz    vertical advection of meridional momentum.
c  fU     zonal Coriolis force.
c  fV     meridional Coriolis force.
c
c=======================================================================
c
#endif
      common /worksp/ ta,ua,va,bcon,tbp,ubp,vbp,fkmup,wsyp,tp,up,vp,
     *       fkmtp,wsxp,tb,ub,vb,fkmu,wsy,t,u,v,fkmt,wsx,tbm,ubm,vbm,
     *       fkmum,wsym,tm,um,vm,fkmtm,wsxm
      FLOAT 
     *      ta (imt,km,nt),ua (imt,km),va (imt,km),bcon(imt,lbc),
     *      tbp(imt,km,nt),ubp(imt,km),vbp(imt,km),fkmup(imt),wsyp(imt),
     *      tp (imt,km,nt),up (imt,km),vp (imt,km),fkmtp(imt),wsxp(imt),
     *      tb (imt,km,nt),ub (imt,km),vb (imt,km),fkmu (imt),wsy (imt),
     *      t  (imt,km,nt),u  (imt,km),v  (imt,km),fkmt (imt),wsx (imt),
     *      tbm(imt,km,nt),ubm(imt,km),vbm(imt,km),fkmum(imt),wsym(imt),
     *      tm (imt,km,nt),um (imt,km),vm (imt,km),fkmtm(imt),wsxm(imt)
c
      common /worksp/ ucl,vcl,uclp,vclp,uclb,vclb,uclbp,vclbp,uclm,vclm,
     *       rhon,rhos,fuw,fvn,fvsu,fvst,fmm,fm,fmp,gm,vmf,vtf,w,wvelt,
     *       wu,wvelu,tempa,tempb
      FLOAT 
     *      ucl   (imt,km),vcl   (imt,km),uclb  (imt,km),vclb  (imt,km),
     *      uclp  (imt,km),vclp  (imt,km),uclbp (imt,km),vclbp (imt,km),
     *      uclm  (imt,km),vclm  (imt,km),rhon  (imt,km),rhos  (imt,km),
     *      fuw   (imt,km),fvn   (imt,km),fvsu  (imt,km),fvst  (imt,km),
     *      fmm   (imt,km),fm    (imt,km),fmp   (imt,km),gm    (imt,km),
     *      vmf(imt,0:kmp1,2),vtf(imt,0:kmp1,ntmin2),
     *      w   (imt,kmp1),wvelt(imt,kmp1),
     *      wu  (imt,kmp1),wvelu(imt,kmp1),
     *      tempa(imt,kmp1),tempb(imt,kmp1)
c
      common /worksp/ dxtq,dxuq,dxt4rq,dxu2rq,dzturq,dztlrq,dzvurq,
     *       dzvlrq,Umet,UUx,UVx,Vmet,VUy,VVy,WUz,WVz,fU,fV,
     *       Uxx,Uyy,Uzz,Vxx,Vyy,Vzz,UTx,VTy,WTz,Txx,Tyy,Tzz,Tsrc
#if defined bndy_rlx | defined cstfrc | defined botfrc
     *       ,Ubrlx,Vbrlx
#endif
#ifdef bndy_rlx
     *       ,Tbrlx
#endif
      FLOAT
     *      dxtq  (imt,km),dxuq  (imt,km),dxt4rq(imt,km),dxu2rq(imt,km),
     *      dzturq(imt,km),dzvurq(imt,km),dztlrq(imt,km),dzvlrq(imt,km),
     *      Umet  (imt,km),UUx   (imt,km),UVx   (imt,km),Vmet  (imt,km),
     *      VUy   (imt,km),VVy   (imt,km),WUz   (imt,km),WVz   (imt,km),
     *      fU    (imt,km),fV    (imt,km),Uxx   (imt,km),Uyy   (imt,km),
     *      Uzz   (imt,km),Vxx   (imt,km),Vyy   (imt,km),Vzz   (imt,km),
     *      UTx   (imt,km),VTy   (imt,km),WTz   (imt,km),Txx   (imt,km),
     *      Tyy   (imt,km),Tzz   (imt,km),Tsrc  (imt,km)
#if defined bndy_rlx | defined cstfrc | defined botfrc
     *     ,Ubrlx (imt,km),Vbrlx (imt,km)
#endif
#ifdef bndy_rlx
     *     ,Tbrlx (imt,km)
#endif
