      subroutine wrt_prf (iprf,j)
c
c=======================================================================
c                                                                    ===
c  This routine writes the desired profiles in acsii format. 	     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <hydro.h>
#include <prf.h>
#include <iounits.h>
#include <pconst.h>
#include <scalar.h>
#include <vertslabs.h>
#include <fullwd.h>
#include <moddat.h>
#include <workspa.h>
#include <rhomean.h>
#if defined resetjulian
#  include <options.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical first,tpoint,vpoint
      integer iprf,j,k
      FLOAT
     *      dstarf,p1
      FLOAT
     *      depthtv(imt,km)
c
      parameter (p1=c1/c10)
c
      save first,dstarf
c
      data first /.true./
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Set starting time.
c-----------------------------------------------------------------------
c
      if (first) then
#ifndef resetjulian
         dstarf = dstart
#else
         dstarf = d0start
#endif
         first = .false.
      endif
c
c-----------------------------------------------------------------------
c  Set profiles parameters and record parameters.
c-----------------------------------------------------------------------
c
      castid = castid + 1
      htime = dstarf+(ttsec-dtts)*sec2day
      hscle(1)= p1
      tpoint = .false.
      vpoint = .false.
c
      if (xbt) then
         hscle(2)= c1em3
         nhvar = 2
         tpoint=.true.
         hdat(1,2) = t(iprf,1,1)
         do k = 1, nhpts-1
            hdat(k+1,2) = t(iprf,k,1)
         enddo
       else if (ctd) then
         hscle(2)= c1em3
         hscle(3)= c1em3
         nhvar = 3
         tpoint=.true.
         hdat(1,2) = t(iprf,1,1)
         hdat(1,3) = t(iprf,1,2) + smean
         do k = 1, nhpts-1
            hdat(k+1,2) = t(iprf,k,1)
            hdat(k+1,3) = t(iprf,k,2) + smean
         enddo
       else if (cm) then
         hscle(2)= p1
         hscle(3)= p1
         nhvar = 3
         vpoint=.true.
         hdat(1,2) = u(iprf,1)
         hdat(1,3) = v(iprf,1)
         do k = 1, nhpts-1
            hdat(k+1,2) = u(iprf,k)
            hdat(k+1,3) = v(iprf,k)
         enddo
      endif
c
      if (tpoint) then
         hlng = tlon(iprf,j)
         hlat = tlat(iprf,j)
         hdpth=hd(iprf,j)*cm2m
         call depthslab(j,0,depthtv)
       else if (vpoint) then
         hlng = vlon(iprf,j)
         hlat = vlat(iprf,j)
         hdpth=hdv(iprf,j)*cm2m
         call depthslab(j,1,depthtv)
      endif
      hdat(1,1) = c0
      do k = 1, nhpts-1
         hdat(k+1,1) = depthtv(iprf,k)*cm2m
      enddo
c
c-----------------------------------------------------------------------
c  Write out hydrographic data.
c-----------------------------------------------------------------------
c
      call wrt_hydro (outprf)
c
#ifdef sunflush
c-----------------------------------------------------------------------
c  Flush output buffers.
c-----------------------------------------------------------------------
c
      call flush (outprf)
c
#endif
      return
      end
