      subroutine Baro_vel
c
c=======================================================================
c                                                                    ===
c  This subroutine computes the Barotropic velocities over the whole ===
c  computational grid at time levels tau and tau-1 by taking         ===
c  derivatives of the stream function.                               ===
c                                                                    ===
c=======================================================================
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fields.h>
#include <fieldsbar.h>
#include <onedim.h>
#include <fullwd.h>
c
      FLOAT diag1,diag2
      integer i,j
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c     Initialize the barotropic velocity arrays
c     -----------------------------------------
      do 10 j=1,jmt
        do 20 i=1,imt
          ubaro(i,j)=c0
          vbaro(i,j)=c0
          ubarob(i,j)=c0
          vbarob(i,j)=c0
20      continue
10    continue
c
c     Compute barotropic velocities for TAU-1 time level
c     --------------------------------------------------
      do 30 j=1,jmtm1
        do 40 i=1,imtm1
          diag1=pb(i+1,j+1)-pb(i,j)
          diag2=pb(i,j+1)-pb(i+1,j)
          ubarob(i,j)=-(diag1+diag2)*dyu2r(j)*min(c1,fkmq(i,j))
     *               *hv(i,j)
          vbarob(i,j)=+(diag1-diag2)*dxu2r(i)*min(c1,fkmq(i,j))
     *               *hv(i,j)*csr(j)
40      continue
30    continue
c
#ifdef cyclic
c
c     Adjust velocities for cyclic boundary conditions
c     ------------------------------------------------ 
      do 50 j=1,jmtm1
        ubarob(1,j)=ubarob(imtm1,j)
        vbarob(1,j)=vbarob(imtm1,j)
        ubarob(imt,j)=ubarob(2,j)
        vbarob(imt,j)=vbarob(2,j)
50    continue
c
#endif
c
c     Compute barotropic velocities for TAU time level
c     ------------------------------------------------
      do 60 j=1,jmtm1
        do 70 i=1,imtm1
          diag1=p(i+1,j+1)-p(i,j)
          diag2=p(i,j+1)-p(i+1,j)
          ubaro(i,j)=-(diag1+diag2)*dyu2r(j)*min(c1,fkmq(i,j))
     *              *hv(i,j)
          vbaro(i,j)=+(diag1-diag2)*dxu2r(i)*min(c1,fkmq(i,j))
     *              *hv(i,j)*csr(j)
70      continue
60    continue
c
#ifdef cyclic
c
c     Adjust velocities for cyclic boundary conditions
c     ------------------------------------------------ 
      do 80 j=1,jmtm1
        ubaro(1,j)=ubaro(imtm1,j)
        vbaro(1,j)=vbaro(imtm1,j)
        ubaro(imt,j)=ubaro(2,j)
        vbaro(imt,j)=vbaro(2,j)
80    continue
c
#endif
c
c
      return
      end
