c
c=======================================================================
c  Include file "bndata.h"
c=======================================================================
c
#ifndef rmdocinc
c  IMX     number of points in each domain boundary.
c  PO      transport and time rate change of vorticity boundary
c          conditions at time TTBDYO.
c  P1      transport and time rate change of vorticity boundary
c          conditions at time TTBDY1.
c  TO      tracer boundary conditions at time TTBDYO.
c  T1      tracer boundary conditions at time TTBDYO.
c  TTBDYO  earlier boundary condition time.
c  TTBDY1  later boundary condition time.
# ifdef surfpress
c  UBAROO  external mode U-velocity boundary conditions at time TTBDYO.
c  UBARO1  external mode U-velocity boundary conditions at time TTBDY1.
# endif
c  UO      internal mode U-velocity boundary conditions at time TTBDYO.
c  U1      internal mode U-velocity boundary conditions at time TTBDY1.
# ifdef surfpress
c  VBAROO  external mode V-velocity boundary conditions at time TTBDYO.
c  VBARO1  external mode V-velocity boundary conditions at time TTBDY1.
# endif
c  VO      internal mode V-velocity boundary conditions at time TTBDYO.
c  V1      internal mode V-velocity boundary conditions at time TTBDY1.
c  ZUNZ    time rate of vertically averaged zonal forcing boundary
c          conditions for the row to the north.
c  ZUSZ    time rate of vertically averaged zonal forcing boundary
c          conditions for the row to the south.
c  ZVNZ    time rate of vertically averaged meridional forcing boundary
c          conditions for the row to the north.
c  ZVSZ    time rate of vertically averaged meridional forcing boundary
c          conditions for the row to the south.
c
c=======================================================================
c
#endif
      common /ibndata/ imx
      integer imx(4)
c
      common /fbndata/ ttbdyo,uo,vo,to,po,ttbdy1,u1,v1,t1,p1,
     *       zusz,zvsz,zunz,zvnz
#ifdef surfpress
     *       ,ubaroo,ubaro1,vbaroo,vbaro1
#endif
      FLOAT 
     *      ttbdyo,uo(ijmx,km,4),vo(ijmx,km,4),to(ijmx,km,4,nt),
     *      po(ijmx,2,4),ttbdy1,u1(ijmx,km,4),v1(ijmx,km,4),
     *      t1(ijmx,km,4,nt),p1(ijmx,2,4),zunz(ijmx,2,4),zusz(ijmx,2,4),
     *      zvnz(ijmx,2,4),zvsz(ijmx,2,4)
#ifdef surfpress
     *      ,ubaroo(ijmx,4),ubaro1(ijmx,4),vbaroo(ijmx,4),vbaro1(ijmx,4)
#endif
c
      integer east,north,south,west
      parameter (west=1,south=2,east=3,north=4)
