      subroutine boundary_press
c
c=======================================================================
c                                                                    ===
c  This routine sets boundary conditions for the Jth slab according  ===
c  to the value of IBDY for the divergence RHS in surface pressure:  ===
c                                                                    ===
c     IBDY = 1   western and eastern boundaries                      ===
c            2   southern boundary                                   ===
c            4   northern boundary                                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <scalar.h>
#include <fields.h>
#include <workspa.h>
#include <bndata.h>
#include <options.h>
#include <iounits.h>
c
#ifndef cyclic
c-----------------------------------------------------------------------
c  Define local data
c-----------------------------------------------------------------------
c
      integer j
c
#endif
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Orlanski radiation (implicit).
c
      if(iopt(3).eq.3) then
#ifndef cyclic
c
c        East and West boundary conditions
c
         do 10 j=2,jmtm1
            call srobc_ori (j,west)
            call srobc_ori (j,east)
 10      continue
#endif
c     
c     South and North boundary conditions
c
         call srobc_ori(1,south)
         call srobc_ori(jmt,north)

c
c  Modified Orlanski radiation (implicit).
c
      elseif(iopt(3).eq.4) then
c
#ifndef cyclic
c        East and West boundary conditions
c
         do 20 j=2,jmtm1
            call srobc_moi (j,west)
            call srobc_moi (j,east)
 20      continue
#endif
c     
c     South and North boundary conditions
c
         call srobc_moi(1,south)
         call srobc_moi(jmt,north)
      else
         write(stdout,900) iopt(3)
         call exitus('BOUNDARY_PRESS')
      endif
c
 900  format(' BOUNDARY_PRESS: invalid boundary on divergence', 
     *     '  IOPT(3) = ',i4)
c
c
      return
      end
