      subroutine boundary_zuvm
c
c=======================================================================
c                                                                    ===
c  This subroutine extends values of uvel,vvel at v-points to the    ===
c  grid boundary i=1|imtm1 ; j=1:jmtm1                               ===
#if defined coast
c  Coastal boundaries are not updated. (Not true, but it should be)  ===
#endif
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <scalar.h>
#include <fields.h>
#include <workspa.h>
#include <bndata.h>
#include <options.h>
#include <iounits.h>
#include <sinfo.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i
#ifndef cyclic
     &        ,j
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Orlanski radiation (implicit).
c-----------------------------------------------------------------------
c
      if(iopt(4).eq.3) then
c
#ifndef cyclic
        do 10 j = 2, jmtm2
          call zrobc_ori (j,west)
          call zrobc_ori (j,east)
  10    continue
c
#endif
        call zrobc_ori (1,south)
        call zrobc_ori (jmtm1,north)
c
c-----------------------------------------------------------------------
c  Modified Orlanski radiation (implicit).
c-----------------------------------------------------------------------
c
      elseif(iopt(4).eq.4) then
c
#ifndef cyclic
        do 20 j = 2, jmtm2
          call zrobc_moi (j,west)
          call zrobc_moi (j,east)
  20    continue
c
#endif
        call zrobc_moi (1,south)
        call zrobc_moi (jmtm1,north)
c
c-----------------------------------------------------------------------
c  Linear extrapolation
c-----------------------------------------------------------------------
c
      elseif(iopt(4).eq.5) then
c
        do 30 i = 2, imum1
          zum(i,1)=c2*zum(i,2)-zum(i,3)
          zvm(i,1)=c2*zvm(i,2)-zvm(i,3)
          zum(i,jmtm1)=c2*zum(i,jmtm2)-zum(i,jmtm2-1)
          zvm(i,jmtm1)=c2*zvm(i,jmtm2)-zvm(i,jmtm2-1)
  30    continue
c
#ifndef cyclic
        do 40 j=2,jmtm2
          zum(1,j)=c2*zum(2,j)-zum(3,j)
          zvm(1,j)=c2*zvm(2,j)-zvm(3,j)
          zum(imtm1,j)=c2*zum(imtm2,j)-zum(imtm2-1,j)
          zvm(imtm1,j)=c2*zvm(imtm2,j)-zvm(imtm2-1,j)
  40    continue
c
        zum(1,1)         = p5*(zum(2,1)+zum(1,2))
        zum(imtm1,1)     = p5*(zum(imtm2,1)+zum(imtm1,2))
        zum(imtm1,jmtm1) = p5*(zum(imtm1,jmtm2)+zum(imtm2,jmtm1))
        zum(1,jmtm1)     = p5*(zum(1,jmtm2)+zum(2,jmtm1))
c
        zvm(1,1)         = p5*(zvm(2,1)+zvm(1,2))
        zvm(imtm1,1)     = p5*(zvm(imtm2,1)+zvm(imtm1,2))
        zvm(imtm1,jmtm1) = p5*(zvm(imtm1,jmtm2)+zvm(imtm2,jmtm1))
        zvm(1,jmtm1)     = p5*(zvm(1,jmtm2)+zvm(2,jmtm1))
c
#else
        zum(1,1)=zum(imtm1,1)
        zvm(1,1)=zvm(imtm1,1)
        zum(imt,1)=zum(2,1)
        zvm(imt,1)=zvm(2,1)
c
        zum(1,jmtm1)=zum(imtm1,jmtm1)
        zvm(1,jmtm1)=zvm(imtm1,jmtm1)
        zum(imt,jmtm1)=zum(2,jmtm1)
        zvm(imt,jmtm1)=zvm(2,jmtm1)
c
#endif
c-----------------------------------------------------------------------
c  Constant (zeroth order) extrapolation
c-----------------------------------------------------------------------
c
      elseif(iopt(4).eq.6) then
c
        do 50 i = 2, imum1
          zum(i,1)=zum(i,2)
          zvm(i,1)=zvm(i,2)
          zum(i,jmtm1)=zum(i,jmtm2)
          zvm(i,jmtm1)=zvm(i,jmtm2)
  50    continue
c
#ifndef cyclic
        do 60 j = 2, jmtm2
          zum(1,j)=zum(2,j)
          zvm(1,j)=zvm(2,j)
          zum(imtm1,j)=zum(imtm2,j)
          zvm(imtm1,j)=zvm(imtm2,j)
  60    continue
c
        zum(1,1)         = zum(2,2)
        zum(imtm1,1)     = zum(imtm2,2)
        zum(imtm1,jmtm1) = zum(imtm2,jmtm2)
        zum(1,jmtm1)     = zum(2,jmtm2)
c
        zvm(1,1)         = zvm(2,2)
        zvm(imtm1,1)     = zvm(imtm2,2)
        zvm(imtm1,jmtm1) = zvm(imtm2,jmtm2)
        zvm(1,jmtm1)     = zvm(2,jmtm2)
c
#else
        zum(1,1)=zum(imtm1,1)
        zvm(1,1)=zvm(imtm1,1)
        zum(imt,1)=zum(2,1)
        zvm(imt,1)=zvm(2,1)
c
        zum(1,jmtm1)=zum(imtm1,jmtm1)
        zvm(1,jmtm1)=zvm(imtm1,jmtm1)
        zum(imt,jmtm1)=zum(2,jmtm1)
        zvm(imt,jmtm1)=zvm(2,jmtm1)
c
#endif
c-----------------------------------------------------------------------
c  Illegal option.
c-----------------------------------------------------------------------
c
      elseif(iopt(4).ne.2) then
        write(stdout,901) iopt(4)
        call exitus('BOUNDARY_ZUVM')
      endif
c
      return
c
901   format(/'Error:  BOUNDARY_ZUVM: ',
     * 'invalid boundary condition on zum, zvm, IOPT(4) =',i4)
c
      end
