      function cycfn (i)
c
c=======================================================================
c                                                                    ===
c  This function attempts to ensure that any integer is correctly    ===
c  mapped to the PE model periodic range [2, imtm1].                 ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     I       Longitudinal position.      (integer)                  ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     CYCFN   Remapped position.          (integer)                  ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c----------------------------------------------------------------------
c  Define global data.
c----------------------------------------------------------------------
c
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,iwk
      integer cycfn
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Shift position so [2, IMTM1] occupies range [0, IMT-3].
c  Use modulus function with IMTM2 to map into [0, IMT-3].
c-----------------------------------------------------------------------
c
      iwk = mod(i-2,imtm2)
c
c-----------------------------------------------------------------------
c  Negative numbers need to be wrapped from the top down.
c-----------------------------------------------------------------------
c
      if (iwk.lt.0) iwk = imtm2 + iwk
c
c-----------------------------------------------------------------------
c  Shift position back to [2, IMTM1].
c-----------------------------------------------------------------------
c
      cycfn = iwk + 2
c
      return
      end
