      subroutine derivs0 (time,pos,vel,tflag)
c
c=======================================================================
c                                                                    ===
c  This routine computes the velocity needed to compute a Lagrangian ===
c  trajectory via a fourth order Runge-Kutta scheme.                 ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     POS    the position vector at the last time (grid,grid,meters; ===
c            real array)                                             ===
c     TIME   new time to compute particle position (real)            ===
c     TFLAG  indicates where in time to compute velocities (integer) ===
c            TFLAG =   0    ->  compute at last time                 ===
c            TFLAG =   1    ->  compute midway in time interval      ===
c            TFLAG = other  ->  compute at new time                  ===
c                                                                    ===
c    Common blocks:                                                  ===
c                                                                    ===
c     /FIELDSBAR/                                                    ===
c                                                                    ===
c     UBARO   grid zonal barotropic velocity at TAU      (real array)===
c     UBAROB  grid zonal barotropic velocity at TAU-1    (real array)===
c     VBARO   grid meridional barotropic velocity at TAU (real array)===
c     VBAROB grid meridional barotropic velocity at TAU-1(real array)===
c                                                                    ===
c     /FULLWD/                                                       ===
c                                                                    ===
c     NDISK   index for unit number, current data.    (integer)      ===
c     NDISKB  index for unit number, previous data.   (integer)      ===
c     LABS    rolling unit numbers for virtual data.  (integer array)===
c                                                                    ===
c     /ONEDIM/                                                       ===
c                                                                    ===
c     CSR     reciprocal of cosine metric factor.      (real vector) ===
c     DXU2R   reciprocal of twice UV x-grid spacing.   (real vector) ===
c     DYU2R   reciprocal of twice UV y-grid spacing.   (real vector) ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     VEL    the velocities needed (real array)                      ===
c                                                                    ===
c     Common blocks:                                                 ===
c                                                                    ===
c     /TRKSCL/                                                       ===
c                                                                    ===
c     DTYP     Drifter type.                           (character)   ===
c     FACTT    time scale.                             (real; sec)   ===
c     FACTXY   horizontal space scale.                 (real; cm)    ===
c     HD       Diameter (height) of extended drifter.  (real; cm)    ===
c                                                                    ===
#if !defined ext_tide | (defined surfpress & defined freesurf)
c  Calls:    BES1D,  OPICK,  VAVGV,  VNTRPV                          ===
# else
c  Calls:    BES1D,  DRFTDV,  OPICK,  VAVGV,  VNTRPV                 ===
#endif
#ifdef cyclic
c            CYCFN                                                   ===
#endif
c                                                                    ===
c  Note:  The variables U, UB, V and VB in the common block /WORKSP/ ===
c         are used as local workspace.                               ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fieldsbar.h>
#include <fullwd.h>
#include <onedim.h>
#include <trkscl.h>
#include <workspa.h>
#include <workspb.h>
#if defined surfpress & defined freesurf
# include <vertical.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical first
      integer i,j,ix,jy,ibry,jbry,jwk,iwk,neu,nev,nsu,nsv,
     *        tflag,iwkp1,jwkp1
#ifdef cyclic
      integer cycfn
#endif
      FLOAT
     *      bes1d,dtc,dto,time,usclr,
     *      uz,uzb,vsclr,vz,vzb,x,xmix,y,ymax,ymjy,z
#ifndef cyclic
     *      ,xmax
#endif
#if  defined surfpress & defined freesurf
     *      ,zeta
#endif
      FLOAT
     *      pos(3),vel(3),uwk1(4),uwk2(4),vwk1(4),vwk2(4)
      parameter (nsu=1+imtkm*nt,nsv=nsu+imtkm,neu=nsu-1+imtkm,
     *           nev=nsv-1+imtkm)
#ifndef cyclic
      save first,usclr,vsclr,xmax,ymax
# else
      save first,usclr,vsclr,ymax
#endif
      data first/.true./
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  On first pass, set bounds for horizontal interpolations.
c-----------------------------------------------------------------------
c
      if(first) then
#ifndef cyclic
        xmax=FLoaT(imtm2)
#endif
        ymax=FLoaT(jmtm2)
        vsclr=factt/facty
        usclr=factt/factx
        first=.false.
      endif
c
c-----------------------------------------------------------------------
c  Set up parameters for linear interpolation in time.
c-----------------------------------------------------------------------
c
      if(tflag.eq.0) then
        dto=c1
        dtc=c0
      elseif(tflag.eq.1) then
        dto=p5
        dtc=p5
      else
        dto=c0
        dtc=c1
      endif
c
c-----------------------------------------------------------------------
c  Set up parameters for spatial interpolations.
c-----------------------------------------------------------------------
c
      x=pos(1)-p5
      y=pos(2)-p5
      z=max(pos(3)*m2cm,c0)
c
      ix=int(x)
      xmix=x-FLoaT(ix)
      ibry=0
#ifndef cyclic
      if(x.lt.c2) then
        ibry=1
      elseif(x.ge.xmax) then
        ibry=2
      endif
#endif
c
      jy=int(y)
      ymjy=y-FLoaT(jy)
      jbry=0
      if(y.lt.c2) then
        jbry=1
      elseif(y.ge.ymax) then
        jbry=2
      endif
c
#if defined surfpress & defined freesurf
c-----------------------------------------------------------------------
c    Reset depth to account for surface elevation
c-----------------------------------------------------------------------
c
      zeta= (c1-ymjy)*
# ifndef cyclic
     *     (etav(ix,jy)*(c1-xmix) + etav(min(ix+1,imtm1),jy)*xmix)+
     *      ymjy*
     *     (etav(ix,min(jy+1,jmtm1))*(c1-xmix) + 
     *     etav(min(ix+1,imtm1),min(jy+1,jmtm1))*xmix)
# else
     *     (etav(ix,jy)*(c1-xmix) + etav(cycfn(ix+1),jy)*xmix)+
     *      ymjy*
     *     (etav(ix,min(jy+1,jmtm1))*(c1-xmix) + 
     *     etav(cycfn(ix+1),min(jy+1,jmtm1))*xmix)
# endif
      z=z-zeta
c
#endif
c-----------------------------------------------------------------------
c  Linearly interpolate horizontal velocities in depth & time.  Cubicly
c  interpolate the velocities in zonal direction.
c-----------------------------------------------------------------------
c
      do 20 j=1,4
        jwk=max(min(jy+j-2,jmtm1),1)
        jwkp1=jwk+1
        call opick(labs(ndisk),nslab,(jwk-1)*nslab+1,nsu,neu,u)
        call opick(labs(ndisk),nslab,(jwk-1)*nslab+1,nsv,nev,v)
        call opick(labs(ndiskb),nslab,(jwk-1)*nslab+1,nsu,neu,ub)
        call opick(labs(ndiskb),nslab,(jwk-1)*nslab+1,nsv,nev,vb)
#if defined ext_tide & (!defined surfpress | !defined freesurf)
        call drftdv (jwk,u,ub,v,vb)
#endif
c
        do 10 i=1,4
c
#ifndef cyclic
          iwk=max(min(ix+i-2,imtm1),1)
          iwkp1=iwk+1
# else
          iwk   = cycfn (ix+i-2)
          iwkp1 = cycfn (iwk+1)
#endif
c
          if (dtyp.ne.'x') then
             call vntrpv (iwk,jwk,z,u,ub,v,vb,uz,uzb,vz,vzb)
           else
             call vavgv (iwk,jwk,z,hd,u,ub,v,vb,uz,uzb,vz,vzb)
          end if
c
          uwk1(i)=(dto*uzb+dtc*uz)
     *            +(ubaro(iwk,jwk)*dtc+ubarob(iwk,jwk)*dto)
          vwk1(i)=(dto*vzb+dtc*vz)
     *            +(vbaro(iwk,jwk)*dtc+vbarob(iwk,jwk)*dto)
  10    continue
c
        uwk2(j)=bes1d(xmix,uwk1(1),uwk1(2),uwk1(3),uwk1(4),ibry)*
     *                                                          csr(jwk)
        vwk2(j)=bes1d(xmix,vwk1(1),vwk1(2),vwk1(3),vwk1(4),ibry)
  20  continue
c
c-----------------------------------------------------------------------
c  Interpolate horizontal velocities to desired meridional position
c  set vertical velocity to zero.
c-----------------------------------------------------------------------
c
      vel(1)=bes1d(ymjy,uwk2(1),uwk2(2),uwk2(3),uwk2(4),jbry)*usclr
      vel(2)=bes1d(ymjy,vwk2(1),vwk2(2),vwk2(3),vwk2(4),jbry)*vsclr
      vel(3)=c0
c
      return
      end
