      subroutine div_fld(uvel,vvel,zt,hhv,fac)
c
c=======================================================================
c                                                                    ===
c  This subroutine calculates the zt=fac*Div(hhv [uvel,vvel])        ===
c                                                                    ===
c=======================================================================
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fullwd.h>
#include <onedim.h>
c
c-----------------------------------------------------------------------
c  Define local variables and arrays.
c-----------------------------------------------------------------------
c
      FLOAT
     *      fluxhorie1,fluxhorie2,fluxhorie,
     *      fluxhoriw1,fluxhoriw2,fluxhoriw,
     *      fluxvertn1,fluxvertn2,fluxvertn,
     *      fluxverts1,fluxverts2,fluxverts,
     *      fluxhori,fluxvert
      FLOAT
     *      zt(imt,jmt),uvel(imt,jmt),vvel(imt,jmt),hhv(imt,jmt),fac
      integer i,j,iend,istr
#ifdef coast
      integer l
#endif
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      do 10 j=1,jmt
         do 10 i=1,imt
            zt(i,j)=c0
 10      continue

      do 40 j=2,jmt-1
c
#ifdef coast
c
c  Choose to compute at sea points only and avoid land points
c
         do 30 l=1,lseg
            istr=isp(j,l)
            if(istr.eq.0) go to 40
            iend=iep(j,l)
#else
c
            istr=2
            iend=imt-1
#endif
            do 20 i=istr,iend
c
               fluxhorie1=hhv(i,j)*uvel(i,j)
               fluxhorie2=hhv(i,j-1)*uvel(i,j-1)
               fluxhorie=p5*(fluxhorie1+fluxhorie2)
c
               fluxhoriw1=hhv(i-1,j)*uvel(i-1,j)
               fluxhoriw2=hhv(i-1,j-1)*uvel(i-1,j-1)
               fluxhoriw=p5*(fluxhoriw1+fluxhoriw2)
c
               fluxhori=(fluxhorie-fluxhoriw)/dxt(i)
c
c
               fluxvertn1=hhv(i,j)*vvel(i,j)
               fluxvertn2=hhv(i-1,j)*vvel(i-1,j)
               fluxvertn=p5*cs(j)*(fluxvertn1+fluxvertn2)
c
               fluxverts1=hhv(i,j-1)*vvel(i,j-1)
               fluxverts2=hhv(i-1,j-1)*vvel(i-1,j-1)
               fluxverts=p5*cs(j-1)*(fluxverts1+fluxverts2)
c
               fluxvert=(fluxvertn-fluxverts)/dyt(j)
c
c
               zt(i,j)=(fluxhori+fluxvert)*fac
c
 20         continue
#ifdef coast
 30      continue
#endif
#ifdef cyclic
         zt(1,j)=zt(imum1,j)
         zt(imu,j)=zt(2,j)
#endif
 40   continue
c
      return
      end
