      subroutine expand_depth
c
c=======================================================================
c                                                                    ===
c  This routine sets the depths at the tracers (T,S)  and velocity   ===
c  (u,v) points. These depths are used to interpolate these fields   ===
c  to hybrid (topography-following) coordinates.                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fields.h>
#include <vertical.h>
#include <scalar.h>
#include <vertslabs.h>
#include <fieldsbar.h>
#include <workspb.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j
      FLOAT
     *     fac1
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Set free surface at the T points.
c
      fac1=c1/grav
      do 100 j=1,jmt
      do 100 i=1,imt
         etat(i,j)=fac1*p(i,j)
         detat(i,j)=ptd(i,j)*fac1
 100  continue
c
c  Set free surface at the U-V points.
c
      do 130 j=1,jmtm1
        do 120 i=1,imtm1
          etav(i,j)=p25*
     *          (etat(i,j)+etat(i+1,j)+etat(i,j+1)+etat(i+1,j+1))
          detav(i,j)=p25*
     *      (detat(i,j)+detat(i+1,j)+detat(i,j+1)+detat(i+1,j+1))
 120    continue
#ifdef cyclic
        etav(1,j)=etav(imtm1,j)
        etav(imt,j)=etav(2,j)
        detav(1,j)=detav(imtm1,j)
        detav(imt,j)=detav(2,j)
#else
        etav(imt,j)=etav(imtm1,j)
        detav(imt,j)=detav(imtm1,j)
#endif
 130  continue
      do 140 i=1,imt
        etav(i,jmt)=etav(i,jmtm1)
        detav(i,jmt)=detav(i,jmtm1)
 140  continue
c
c-----------------------------------------------------------------------
c  Set the depths ratios at tracer and velocity points and the inverse
c  of bottom depth at v-points
c-----------------------------------------------------------------------
c
      do 200 j=1,jmt
      do 200 i=1,imt
         fractb(i,j)=fract(i,j)
         fract(i,j)=c1+etat(i,j)/hd(i,j)
         fracvb(i,j)=fracv(i,j)
         fracv(i,j)=c1+etav(i,j)/hdv(i,j)
         hdvcf(i,j)=hdv(i,j)+etav(i,j)
         hvav(i,j)=c1/hdvcf(i,j)
         hdvcf(i,j)=hdvcf(i,j)*min(fkmq(i,j),c1)
 200  continue
c
      return
      end
