      subroutine external_vel
c
c=======================================================================
c                                                                    ===
c EXTERNAL_VEL computes vertically averaged velocity at interior     ===
c       velocity points- UBARONEW for TAU+1 - and updates            ===
c       vertically averaged velocity:                                ===
c       if mxpas .FALSE.                                             ===
c         UBARO -> UBAROB;  UBARONEW -> UBARO                        ===
c       else                                                         ===
c         UBARONEW -> UBARO                                          ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fullwd.h>
#include <scalar.h>
#include <onedim.h>
#include <fieldsbar.h>
#include <workspb.h>
#include <sinfo.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j
#ifdef coast
      integer istr,iend,jptr,l
#endif
      FLOAT 
     *      presscorru,presscorrv,fx,fac
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Solve for the updated barotropic velocities.
c-----------------------------------------------------------------------
c
c  Set time scaling.
c
#ifdef freesurf
      fx=alphav*c2dtsf
#else
      fx=c2dtsf
#endif
      if((mix.eq.1).and.eb) then
         fac=c1
      else
         if((mxp.ne.0).or.(mix.ne.0)) then
            fac=p5
         else
            fac=c1
         endif
      endif
      fx=fac*fx
c
c  Update barotropic velocity with time change of surface pressure gradient.
c
      do 20 j=1,jmtm1
#ifdef coast
c
c  Choose to compute at sea points only and avoid land points
c
         jptr = min( max(j, 2), jmtm2)
c
         do 20 l=1,lseg
            istr=isq(jptr,l)
            if(istr.eq.0) go to 20
# ifndef cyclic
            if ((istr.eq.2).and.(fkmq(2,jptr).gt.c0)) istr=1
# endif
            iend=ieq(jptr,l)
            if ((iend.eq.imtm2).and.(fkmq(imtm2,jptr).gt.c0)) iend=imtm1
            do 10 i=istr,iend
#elif !defined cyclic
c
            do 10 i=1,imtm1
#else
c
            do 10 i=2,imtm1
#endif
c
               presscorru=(ptd(i+1,j+1)+ptd(i+1,j))-(ptd(i,j+1)
     *                     +ptd(i,j))
               presscorru=fx*presscorru*csr(j)*dxu2r(i)
c
               presscorrv=(ptd(i+1,j+1)+ptd(i,j+1))-(ptd(i+1,j)
     *                     +ptd(i,j))
               presscorrv=fx*presscorrv*dyu2r(j)
c
               ubaronew(i,j)=ubarhat(i,j)-presscorru
               vbaronew(i,j)=vbarhat(i,j)-presscorrv
c
  10        continue
  20  continue
c
#ifdef cyclic
c  Impose periodic boundary conditions.
c
      do 30 j = 1, jmtm1
         ubaronew(1,j)=ubaronew(imtm1,j)
         vbaronew(1,j)=vbaronew(imtm1,j)
         ubaronew(imt,j)=ubaronew(2,j)
         vbaronew(imt,j)=vbaronew(2,j)
  30  continue
#endif
c
c-----------------------------------------------------------------------
c  Update other barotropic velocity storage space.
c-----------------------------------------------------------------------
c
      if(.not.mxpas2) then
c
         do 50 j=1,jmtm1
#ifdef coast
c
c  Choose to update at sea points only and avoid land points
c
            jptr = min( max(j, 2), jmtm2)
c
            do 50 l=1,lseg
               istr=isq(jptr,l)
               if(istr.eq.0) go to 50
               if ((istr.eq.2).and.(fkmq(2,jptr).gt.c0)) istr=1
               iend=ieq(jptr,l)
               if ((iend.eq.imum1).and.(fkmq(imum1,jptr).gt.c0))
     &            iend=imu
               do 40 i=istr,iend
#else
c
               do 40 i=1,imu
#endif
                  ubarob(i,j)=ubaro(i,j)
                  vbarob(i,j)=vbaro(i,j)
                  ubaro(i,j)=ubaronew(i,j)
                  vbaro(i,j)=vbaronew(i,j)
  40           continue
  50     continue
c
      else
c
         do 70 j=1,jmtm1
#ifdef coast
c
c  Choose to compute at sea points only and avoid land points
c
            jptr = min( max(j, 2), jmtm2)
c
            do 70 l=1,lseg
               istr=isq(jptr,l)
               if(istr.eq.0) go to 70
               if ((istr.eq.2).and.(fkmq(2,jptr).gt.c0)) istr=1
               iend=ieq(jptr,l)
               if ((iend.eq.imum1).and.(fkmq(imum1,jptr).gt.c0))
     &            iend=imu
               do 60 i=istr,iend
#else
               do 60 i=1,imu
#endif
                  ubaro(i,j)=ubaronew(i,j)
                  vbaro(i,j)=vbaronew(i,j)
  60           continue
  70     continue
c
      endif
c            
      return
      end
