      subroutine extrap (nval,dep,val,xtrp)
c
c=======================================================================
c                                                                    ===
c  This subroutine provides extrapolated values for those values so  ===
c  indicated.                                                        ===
c                                                                    ===
c  Arguments:                                                        ===
c                                                                    ===
c  NVAL   the number of values to consider (input; integer).         ===
c  DEP    the depth at which values are sought (input; real).        ===
c  VAL    on input both the accepted values and those with           ===
c         questionable extrapolation.  On output both the accepted   ===
c         values and the corrected extrapolations (input/output;     ===
c         real array).                                               ===
c  XTRP   flags to indicate whether each value is accepted or        ===
c         a questionable extrapolation (input; logical array).       ===
c         XTRP(i) = .true.   =>  an extrapolated value.              ===
c         XTRP(i) = .false.  =>  an accepted value.                  ===
c                                                                    ===
#ifndef hpg4
c  Calls:  EXTRAP2                                                   ===
# else
c  Calls:  EXTRAP2,  EXTRAP4                                         ===
#endif
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer nval
#ifdef hpg4
     *        ,i,j,n
      integer i2(4)
#endif
      logical xtrp(nval)
#ifdef hpg4
     *      ,xtrp2(4),xtrp2d(4,4)
#endif
      FLOAT
     *      dep
      FLOAT
     *      val(nval)
#ifdef hpg4
     *      ,val2(4),val2d(4,4)
c
      save i2
      data i2 /6,10,7,11/
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifndef hpg4
c-----------------------------------------------------------------------
c  Interpolate values depending on the number of acceptible values.
c-----------------------------------------------------------------------
c
      call extrap2 (val,xtrp)
c
# else
c-----------------------------------------------------------------------
c  Use second order methods to ensure central 2x2 sub-array.
c-----------------------------------------------------------------------
c
      do 10 n = 1, 4
         val2(n)  = val(i2(n))
         xtrp2(n) = xtrp(i2(n))
  10  continue
c
      call extrap2 (val2,xtrp2)
c
      do 20 n = 1, 4
         val(i2(n))  = val2(n)
         xtrp(i2(n)) = xtrp2(n)
  20  continue
c
c-----------------------------------------------------------------------
c  Extrapolate edge values based on central values.  Extrapolate corner
c  values based on neighboring edge values.
c-----------------------------------------------------------------------
c
      n = 0
      do 30 i = 1, 4
      do 30 j = 1, 4
         n           = n + 1
         val2d(i,j)  = val(n)
         xtrp2d(i,j) = xtrp(n)
  30  continue
c
      call extrap4 (val2d,xtrp2d)
c
      n = 0
      do 40 i = 1, 4
      do 40 j = 1, 4
         n       = n + 1
         val(n)  = val2d(i,j)
         xtrp(n) = xtrp2d(i,j)
  40  continue
c
#endif
      return
      end
