      subroutine extrap4 (val,xtrp)
c
c=======================================================================
c                                                                    ===
c  This routine performs horizontal extrapolation to the vertically  ===
c  extrapolated values in the passed 4x4 subfield.  This routine     ===
c  assumes that the central 2x2 sub-array is all "valid".            ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     VAL    Accepted & questionable values.        (real array)     ===
c     XTRP   flags to indicate extrapolation.       (logical array)  ===
c               [.true.]   an extrapolated value.                    ===
c               [.false.]  an accepted value.                        ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     VAL    Accepted & corrected values.           (real array)     ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer n
      integer i0(3,8),j0(3,8),i1(3,4),j1(3,4)
      logical xtrp(4,4)
      FLOAT
     &      val(4,4)
c
      save i0,j0,i1,j1
c
      data i0 /1,2,3,
     &         1,2,3,
     &         2,2,2,
     &         3,3,3,
     &         4,3,2,
     &         4,3,2,
     &         3,3,3,
     &         2,2,2/
      data j0 /3,3,3,
     &         2,2,2,
     &         1,2,3,
     &         1,2,3,
     &         2,2,2,
     &         3,3,3,
     &         4,3,2,
     &         4,3,2/
      data i1 /1,1,2,
     &         1,1,2,
     &         4,3,4,
     &         4,3,4/
      data j1 /4,3,4,
     &         1,2,1,
     &         1,1,2,
     &         4,4,3/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Linearly extrapolate to sides.
c-----------------------------------------------------------------------
c
      do 10 n = 1, 8
         if (xtrp(i0(1,n),j0(1,n))) then
            val(i0(1,n),j0(1,n)) = c2*val(i0(2,n),j0(2,n))+
     &                             cm1*val(i0(3,n),j0(3,n))
         endif
 10   continue
c
c-----------------------------------------------------------------------
c  Average adjacent side points to corners.
c-----------------------------------------------------------------------
c
      do 20 n = 1, 4
         if(xtrp(i1(1,n),j1(1,n))) then
            val(i1(1,n),j1(1,n)) = p5*(val(i1(2,n),j1(2,n))+
     &                                 val(i1(3,n),j1(3,n)))
         endif
 20   continue
c
      return
      end
