c
c=======================================================================
c  Include file "fullwd.h".
c=======================================================================
c
#ifndef rmdocinc
c  D0START    Starting time.   (modified Julian day)
c             Only active if CPP option "resetjulian" is active.
c  DIAGTS     logical activated (.TRUE.) during a diagnostic timestep.
c  EB         logical activated (.TRUE.) in a Euler backward timestep
c             and (.FALSE.) in a forward timestep for time mixing.
c  EOTS       logical implying end of a timestep. Always true except
c             for the first pass of an Euler backward timestep.
c  ITT        timestep counter; total number ot timesteps completed.
c  IEQ        ending ocean x-index coordinate at velocity points.
c  IEZ        ending ocean x-index coordinate at tracer points.
c  ISQ        starting ocean x-index coordinate at velocity points.
c  ISZ        starting ocean x-index coordinate at tracer points.
c  KAR        KAR(K)=K used to enable vectorization.
c  KFLDS      disk unit number (12) fo 2-D horizontal fields and start
c             and end indices.
c  KMT        number of vertical level of ocean at tracer points at
c             row J.
c  KMTP       number of vertical level of ocean at tracer points at
c             row J+1.
c  KMU        number of vertical level of ocean at velocity points at
c             row J.
c  KMUP       number of vertical level of ocean at velocity points at
c             row J+1.
c  KONTRL     disk unit number (11) for timestep counter.
c  LABS       disk unit number (13-15) for slabs.
c  MIX        mixing timestep indicator:
c             MIX=0    no mixing timestep.
c             MIX=1    mixing timestep.
c  MIXTS      logical activated (.TRUE.) during a mixing timestep.
c  MSCAN      current number of relaxation scans performed.
c  MXP        Euler backward timestep switch:
c             MXP=1   second pass of Euler backward timeste.
c             MXP=0   otherwise.
c  MXPAS2     logical activated (.TRUE.) for a second pass during
c             a mixing timestep.
c  MXSCAN     maximum number of relaxation scans permitted.
c  NA         utility integer used to enable re-start file.
c  NB         utility integer available for use.
c  NC         utility integer available for use.
c  NCON       number of passes through convection loop.
c  NDISK      disk unit for current data (timestep TAU).
c  NDISKA     disk unit for future data (timestep TAU+1).
c  NDISKB     disk unit for previuos data (timeste TAU-1).
c  NFIRST     initialization switch:
c             NFIRST=1  start from scatch.
c             NFIRST=0  start using re-start file.
c  NISLE      number of island in the ocean basin.
c  NLAST      abs(NLAST) is the number of timesteps to compute.  If
c             negative, write re-start file at this timestep.
c  NMIX       number of timesteps between mixing timestep.
c  NNERGY     number of timesteps between energy diagnostics output.
# if defined AsselinFilt | defined surfpress
c  _NU        Asselin filter parameter
# endif
c  NTDG       number of initial timesteps with frozen tracers; used
c             during diagnostic initialization.
c  NTSI       number of timesteps between print of single line of
c             information.
c  NTSOUT     number of timesteps between output of data.
c  NWRITE     number used to save re-start data every NWRITE timesteps
c  PRNTSI     logical activated (.TRUE.) during printing information
c             timestep.
c  WNETCDF    switch that activates writting of output NetCDF files.
c  WRTTS      logical activated (.TRUE.) during an output timestep.
# ifdef coast
c  ICOAST     coastal segment x-index coordinate.
c  JCOAST     coastal segment y-index coordinate.
#  if defined surfpress | defined pindex
c  IEP        As for IEZ but for the surface pressure formulation.
c  JEP        As for JEZ but for the surface pressure formulation.
c  ISP        As for ISZ but for the surface pressure formulation.
c  JSP        As for JSZ but for the surface pressure formulation.
#  endif
c  JEQ        ending ocean y-index coordinate at velocity points.
c  JEZ        ending ocean y-index coordinate at tracer points.
c  JSQ        starting ocean y-index coordinate at velocity points.
c  JSZ        starting ocean y-index coordinate at tracer points.
#  ifdef nest2smaller
c  LANDP      transport streamfunction land/sea mask.
#  endif
c  LANDT      land/sea mask at tracer points.
c  LANDV      lans/sea mask at velocity points.
c  LENCOAST   number of points in each coastal segment.
c  NCSEG      number of coastal segments.
#  ifdef islands
c  IEIS       ending x-index coordinate of island box.
c  ISIS       starting x-index coordinate of island box.
c  JEIS       ending y-index coordinate of island box.
c  JSIS       starting y-index coordinate of island box.
#  endif
# endif
c
c=======================================================================
c
#endif
      common /ifullwd/ itt,nfirst,nlast,nmix,nnergy,nwrite,na,nb,nc,
     *       mxscan,ndiskb,ndisk,ndiska,kontrl,kflds,labs,mix,mxp,mscan,
     *       ntsi,kar,kmt,kmtp,kmu,kmup,eb,diagts,eots,mixts,mxpas2,
     *       prntsi,wnetcdf,wrtts,ntsout,isz,iez,isq,ieq,
#ifdef coast
# ifdef islands
     *       isis,ieis,jsis,jeis,nisle,
# endif
     *       jsz,jez,jsq,jeq,landt,landv,ncseg,lencoast,icoast,jcoast,
# ifdef nest2smaller
     *       landp,
# endif
# if defined pindex | defined surfpress
     *       isp,iep,jsp,jep,
# endif
#endif     
     *       ncon,ntdgn
      logical diagts,eb,eots,mixts,mxpas2,prntsi,wnetcdf,wrtts
      integer itt,kflds,kontrl,mix,mscan,mxp,mxscan,na,nb,nc,ncon,ndisk,
     *        ndiska,ndiskb,nfirst,nlast,nmix,nnergy,ntdgn,ntsi,ntsout,
     *        nwrite
      integer ieq(jmt,lseg),iez(jmt,lseg),isq(jmt,lseg),isz(jmt,lseg),
     *        kar(km),kmt(imt),kmtp(imt),kmu(imt),kmup(imt),labs(3)
#ifdef coast
# ifdef islands
      integer ieis(misle),isis(misle),jeis(misle),jsis(misle),nisle
# endif
      integer icoast(mclen,mcseg),jcoast(mclen,mcseg),jez(imt,lseg),
     *        jsz(imt,lseg),landt(imt,jmt),landv(imt,jmt),ncseg,
     *        lencoast(mcseg),jsq(imt,lseg),jeq(imt,lseg)
# ifdef nest2smaller
     *        ,landp(imt,jmt)
# endif
# if defined pindex | defined surfpress
     *        ,isp(jmt,lseg),iep(jmt,lseg),jsp(imt,lseg),jep(imt,lseg)
# endif
#endif     
c
      common /ffullwd/ dstart,d0start,ttsec,ttbdy,area,volume,akntrl,
     *                 pad,plicin,plicex
#if defined  AsselinFilt | defined surfpress
     *                 ,_nu
      FLOAT
     *        _nu
#endif
      FLOAT 
     *      dstart,d0start,ttsec,ttbdy,area,volume,akntrl(6),pad(10),
     *      plicin,plicex
