      subroutine get_thickb (j,keytv,dzqz,dzzqz,kzz)
c
c=======================================================================
c                                                                    ===
c  This routine computes the basic level thicknesses from the        ===
c  supplied depths at the middle of the boxes (at previous time)     ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     J       Slab index for depths.               (integer)         ===
c     KEYTV   Flag to select T or V grid.          (integer)         ===
c     KZZ     Number of levels in DZZQZ.           (integer)         ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /VERTICAL/                                                        ===
c                                                                    ===
c     DZT   Thicknesses of T vertical boxes.        (real array; cm) ===
c     DZV   Thicknesses of UV vertical boxes.       (real array; cm) ===
c     FRACTB   expansion coefficient for depth at t-points           ===
c     FRACVB   expansion coefficient for depth at v-points           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     DZQZ    The thickness of a vertical box.      (real array; cm) ===
c     DZZQZ   the vertical spacing between levels.  (real array; cm) ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <vertical.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,k,keytv,kzz
#ifndef barotropic
      integer km1
#endif
      FLOAT
     *      dzqz(imt,km),dzzqz(imt,kzz)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Extract box thicknesses.
c-----------------------------------------------------------------------
c
      if (keytv.eq.tgrid) then
         do 10  i = 1, imt
         do 10  k = 1, km
            dzqz(i,k) = dzt(i,j,k)*fractb(i,j)
  10     continue
       else
         do 20 i = 1, imt
         do 20 k = 1, km
            dzqz(i,k) = dzv(i,j,k)*fracvb(i,j)
  20     continue
      endif
c
c-----------------------------------------------------------------------
c  Compute spacing between levels.
c-----------------------------------------------------------------------
c
      do 30 i = 1, imt
        dzzqz(i,1)    = p5*dzqz(i,1)
        dzzqz(i,kmp1) = p5*dzqz(i,km)
  30  continue
c
#ifndef barotropic
      do 50 k = 2, km
         km1 = k-1
         do 40 i = 1, imt
            dzzqz(i,k) = p5*(dzqz(i,k)+dzqz(i,km1))
  40     continue
  50  continue
#endif
c
      return
      end
