      subroutine h_force(uf,vf,fac)
c
c=======================================================================
c                                                                    ===
c  H_FORCE computes the horizontal force balanced by the action of   ===
c       surface pressure gradients in the water column.              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fullwd.h>
#include <scalar.h>
#include <onedim.h>
#include <fieldsbar.h>
#include <sinfo.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j
      integer istr,iend
#ifdef coast
      integer l
#endif
      FLOAT
     *uf(imt,jmt),vf(imt,jmt),fac
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      do 10 j=1,jmt
      do 10 i=1,imt
         uf(i,j)=c0
         vf(i,j)=c0
 10   continue
      do 40 j=2,jmt-2
c
#ifdef coast
c
c  Choose to compute at sea points only and avoid land points
c
         do 30 l=1,lseg
            istr=isq(j,l)
            if(istr.eq.0) go to 40
            iend=ieq(j,l)
#else
c
            istr=2
            iend=imt-1
#endif
            do 20 i=istr,iend
#ifdef freesurf
               uf(i,j)=thetasd*ubarhat(i,j)+(c1-thetasd)
     *              *ubarob(i,j)+ubaro(i,j)
               vf(i,j)=thetasd*vbarhat(i,j)+(c1-thetasd)
     *              *vbarob(i,j)+vbaro(i,j)
 20         continue
 30      continue
 40   continue
      fac= c1/(alphav*thetasd*c2dtsf)
#else
                uf(i,j)=ubarhat(i,j)
                vf(i,j)=vbarhat(i,j)
 20         continue
 30      continue
 40   continue
      fac= c1/c2dtsf
#endif
c
c Extend to outer boundary nodes (open boundaries)
c
      do 50 j=1,jmtm1
         if(fkmq(2,j).gt.c0) then
            i=1
#ifdef freesurf
            uf(i,j)=thetasd*ubarhat(i,j)+(c1-thetasd)
     *          *ubarob(i,j)+ubaro(i,j)
            vf(i,j)=thetasd*vbarhat(i,j)+(c1-thetasd)
     *          *vbarob(i,j)+vbaro(i,j)
#else
            uf(i,j)=ubarhat(i,j)
            vf(i,j)=vbarhat(i,j)
#endif
         endif
c
         if(fkmq(imum1,j).gt.c0) then
            i=imu
#ifdef freesurf
            uf(i,j)=thetasd*ubarhat(i,j)+(c1-thetasd)
     *          *ubarob(i,j)+ubaro(i,j)
            vf(i,j)=thetasd*vbarhat(i,j)+(c1-thetasd)
     *          *vbarob(i,j)+vbaro(i,j)
#else
            uf(i,j)=ubarhat(i,j)
            vf(i,j)=vbarhat(i,j)
#endif
         endif
 50   continue
c
      do 60 i=2,imum1
         if(fkmq(i,2).gt.c0) then
            j=1
#ifdef freesurf
            uf(i,j)=thetasd*ubarhat(i,j)+(c1-thetasd)
     *          *ubarob(i,j)+ubaro(i,j)
            vf(i,j)=thetasd*vbarhat(i,j)+(c1-thetasd)
     *          *vbarob(i,j)+vbaro(i,j)
#else
            uf(i,j)=ubarhat(i,j)
            vf(i,j)=vbarhat(i,j)
#endif
         endif
c
         if(fkmq(i,jmtm2).gt.c0) then
            j=jmtm1
#ifdef freesurf
            uf(i,j)=thetasd*ubarhat(i,j)+(c1-thetasd)
     *          *ubarob(i,j)+ubaro(i,j)
            vf(i,j)=thetasd*vbarhat(i,j)+(c1-thetasd)
     *          *vbarob(i,j)+vbaro(i,j)
#else
            uf(i,j)=ubarhat(i,j)
            vf(i,j)=vbarhat(i,j)
#endif
         endif
 60   continue
c
      return
      end
