      subroutine meanrho
c
c=======================================================================
c                                                                    ===
c  This routine computes the background density field RHOBAR at      ===
c  each grid point.                                                  ===
c                                                                    ===
c=======================================================================
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <onedim.h>
#include <options.h>
#include <hybrid.h>
#include <rhomean.h>
#if defined surfpress & defined freesurf 
# include <vertical.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,k
#if defined surfpress & defined freesurf 
     *        ,np
      logical first
#endif
      FLOAT
     *      der1,derkm,frsd,z
#if defined surfpress & defined freesurf 
     *     ,zrho
#else
     *     ,sal,tem
#endif
      FLOAT
     *      depth(imt,km),rho(imt,km),
     *      s(imt,km),t(imt,km),wk(mprof)
#if defined surfpress & defined freesurf 
     *      ,d2r(mprof),rhoprof(mprof)
#else
     *      ,d2s(mprof),d2t(mprof)
#endif
      parameter (der1=c1e30,derkm=c1e30)
c
#if defined surfpress & defined freesurf 
      save d2r,first,rhoprof
c
      data first/.true./
c
#endif
c=======================================================================
c  Begin executable code.
c=======================================================================
#if defined surfpress & defined freesurf 
c
c  Create initial background density field on default levels.
c
      if (first) then
         first=.false.
         np=0
         do 10 i=1,imt
         do 10 k=1,km
            np=np+1
            if(np.gt.nprof)then
               t(i,k)=tinit(nprof,1)            
               s(i,k)=tinit(nprof,2)-smean
               depth(i,k)=tinit(nprof,3)
            else
               t(i,k)=tinit(np,1)            
               s(i,k)=tinit(np,2)-smean
               depth(i,k)=tinit(np,3)
            endif
  10     continue
         call state(t,s,depth,rho)
         np=0
         do 20 i=1,imt
         do 20 k=1,km
            np=np+1
            if(np.le.nprof)then
               rhoprof(np)=rho(i,k)
            endif
  20     continue
         if (iflag(2).eq.1) then
            call spline(tinit(1,3),rhoprof,nprof,der1,derkm,d2r,wk)
         endif
      endif
c
c  Interpolate background density field to current levels.
c
      do 40 j=1,jmt
        call depthslab(j,tgrid,depth)
        do 30 i=1,imt
        do 30 k=1,km
          z=depth(i,k)-etat(i,j)
          if (iflag(2).eq.1) then
            call splint(tinit(1,3),rhoprof,d2r,nprof,z,zrho,frsd)
          else
            call lintrp(nprof,tinit(1,3),rhoprof,1,z,zrho)
          end if
          rhobar(i,j,k)=zrho
  30    continue
  40  continue
#else
c
c  Calculate background density field
c
      if (iflag(2).eq.1) then
        call spline(tinit(1,3),tinit(1,1),nprof,der1,derkm,d2t,wk)
        call spline(tinit(1,3),tinit(1,2),nprof,der1,derkm,d2s,wk)
      end if
c
      do 30 j=1,jmt
        call depthslab(j,tgrid,depth)
        do 10 i=1,imt
        do 10 k=1,km
          z=depth(i,k)
          if (iflag(2).eq.1) then
            call splint(tinit(1,3),tinit(1,1),d2t,nprof,z,tem,frsd)
            call splint(tinit(1,3),tinit(1,2),d2s,nprof,z,sal,frsd)
           else
            call lintrp(nprof,tinit(1,3),tinit(1,1),1,z,tem)
            call lintrp(nprof,tinit(1,3),tinit(1,2),1,z,sal)
          end if
          t(i,k)=tem
          s(i,k)=sal-smean
  10    continue
        call state(t,s,depth,rho)
        do 20 k=1,km
        do 20 i=1,imt
          rhobar(i,j,k)=rho(i,k)
  20    continue
  30  continue
#endif
c
      return
      end
