      subroutine oibndry(j)
c
c=======================================================================
c                                                                    ===
c  This routine updates boundary condition for the Jth slab.  It     ===
c  replaces  the fields in  common block  BNDATA  with their new     ===
c  values after assimilation.                                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <fields.h>
#ifdef surfpress
# include <fieldsbar.h>
#endif
#include <workspa.h>
#include <bndata.h>
#include <oiopts.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,k,m
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c=======================================================================
c  Update internal mode velocities boundary conditions
c=======================================================================
c
      if(ioiuv.eq.1) then
c
c  Western and eastern boundaries
c
        do 10 k=1,km
          uo(j,k,west)=u(1,k)
          vo(j,k,west)=v(1,k)
          uo(j,k,east)=u(imtm1,k)
          vo(j,k,east)=v(imtm1,k)
  10    continue
c
c  Southern and northern boundaries
c
        if(j.eq.1) then
          do 20 k=1,km
          do 20 i=1,imtm1
            uo(i,k,south)=u(i,k)
            vo(i,k,south)=v(i,k)
  20      continue
        else if(j.eq.jmtm1) then
          do 30 k=1,km
          do 30 i=1,imtm1
            uo(i,k,north)=u(i,k)
            vo(i,k,north)=v(i,k)
  30      continue
        endif
      endif
c
c=======================================================================
c  Update tracer boundary conditions.
c=======================================================================
c
      do 70 m=1,nt
        if(ioits(m).eq.1) then
c
c  Western and eastern boundaries
c
          do 40 k=1,km
            to(j,k,west,m)=t(1,k,m)
            to(j,k,east,m)=t(imt,k,m)
  40      continue
c
c  Southern and northern boundaries
c
          if(j.eq.1) then
            do 50 k=1,km
            do 50 i=1,imt
              to(i,k,south,m)=t(i,k,m)
  50        continue
          else if(j.eq.jmtm1) then
            do 60 k=1,km
            do 60 i=1,imt
              to(i,k,north,m)=t(i,k,m)
  60        continue
          endif
        endif
  70  continue
c
c=======================================================================
#ifndef surfpress
c  Update transport stream function boundary conditions
#else
c  Update surface pressure boundary conditions
#endif
c=======================================================================
c
      if(ioip.eq.1) then
c
c  Western and eastern boundaries
c
        po(j,1,west)=p(1,j)
        po(j,1,east)=p(imt,j)
c
c  Southern and northern boundaries
c
        if(j.eq.1) then
          do 80 i=1,imt
            po(i,1,south)=p(i,1)
  80      continue
        else if(j.eq.jmt) then
          do 90 i=1,imt
            po(i,1,north)=p(i,jmt)
  90      continue
        endif
      endif
c
#ifdef surfpress
c=======================================================================
c  Update external mode velocities boundary conditions
c=======================================================================
c
      if(ioiuvb.eq.1) then
c
c  Western and eastern boundaries
c
        ubaroo(j,west)=ubaro(1,j)
        vbaroo(j,west)=vbaro(1,j)
        ubaroo(j,east)=ubaro(imtm1,j)
        vbaroo(j,east)=vbaro(imtm1,j)
c
c  Southern and northern boundaries
c
        if(j.eq.1) then
          do 100 i=1,imtm1
            ubaroo(i,south)=ubaro(i,j)
            vbaroo(i,south)=vbaro(i,j)
 100      continue
        else if(j.eq.jmtm1) then
          do 110 i=1,imtm1
            ubaroo(i,north)=ubaro(i,j)
            vbaroo(i,north)=vbaro(i,j)
 110      continue
        endif
      endif
c
#endif 
      return
      end
