c
c=======================================================================
c  Include file "param.h" for PEMODEL.
c=======================================================================
#ifndef rmdocinc
c
c  IMT     Number of tracer points in the x-direction.
c  JMT     Number of tracer points in the y-direction.
c  IJMX    Either IMT or JMT, whichever is greater.
c  KM      Number of vertical levels.
c  LBC     Number of arrays of slab incidental data (usually, LBC=2).
c  LSEG    Maximum number of sets of Start and End indices per row or
c          per column (number of coastal segments plus one).
# ifdef bioDuse
c  LM      Number of intervals in light spectra (for PAR).
# endif
c  MISLE   Maximum number of islands in the model basin.
c  MPROF   Maximum number of points in mean TS profile.
c  NT      Number of tracer type variables (generally, NT=2 for T & S).
# ifdef coast
c  MCLEN   Maximum number of points in a coastal segment.
c  MCSEG   Maximum number of coastal segments.
# endif
# ifdef ext_tide
c  MAXCOMP Maximum number of tidal components.
# endif
# if defined posmxtid & ( !defined mixtide | !defined ext_tide )
c  TDBOXMX maximum number of tidally active boxes.
# endif
# ifdef extraction
c  MSUBDOM maximum number of subdomains to extract.
c  XIMT    maximum number of tracer points in the x-direction to
c          extract.
c  XKM     maximum number of vertical levels to extract.
# endif
# ifdef peprf
c  MHDR    Maximum number of lines of text in the file header.
c  MHFLDS  Maximum number of field types supported.
c  MHPTS   Maximum number of data points per station.
c  MHVAR   Maximum number of variables per station.  (MHVAR<=MHFLDS)
c  MNBPRF  Maximum number of profile per instrument.
# endif
# if defined nest2larger | defined nest2smaller
c  XMDAT   maximum number of points in arrays for passing to external
c          models.  A loose upper bound is given by max(nx*ny*nz)
#  if defined nest_ext2lrgr | defined nest_ext2smlr
c  XMNDAT  maximum number of points in arrays for passing to external
c          models.  Loose bound max(nx*ny) for all nested models.
#  endif
# endif
# if defined surfpress | defined pcg5
c  NMAX    SPARSKIT workspace ~IM*JM (number of rows in Ellip. Matrix)
c  NZMAX   SPARSKIT workspace. ~nmax*2*(fillin+1)
c  LWK     SPARSKIT workspace.
c  ISESIZE  >= LSEG*JMT 
# endif
c
c=======================================================================
#endif
c
      integer ijmx,imt,imtjmt,imtkm,imtm1,imtm2,imtp1,imu,imum1,imum2,
     *        jmt,jmtm1,jmtm2,jmtp1,jscan,km,kmm1,kmp1,kmp2,lbc,lseg,
     *        misle,mprof,ndices,nkflds,nslab,nswich,nt,ntmin2,nwds
#ifdef coast
      integer mcseg,mclen
#endif
#ifdef ext_tide
      integer maxcomp
#endif
#if defined posmxtid & ( !defined mixtide | !defined ext_tide )
      integer tdboxmx
#endif
#ifdef extraction
      integer msubdom,ximt,ximtkm,xkm
#endif
#ifdef peprf
      integer mhdr,mhflds,mhpts,mhvar,mnbprf
#endif
#if defined nest2larger | defined nest2smaller
      integer xmdat
#endif
#ifdef bioDuse
       integer lm
#endif
c
#ifndef rmdocinc
c-----------------------------------------------------------------------
c  User set parameters.
c-----------------------------------------------------------------------
c
#endif
      parameter(imt=53,jmt=90,ijmx=90,km=16,lseg=5,misle=4,lbc=2)
#if defined codunlim | defined codlim
# define CodAdd 1
#else
# define CodAdd 0
#endif
#if defined bioAnder
      parameter(nt=7+CodAdd)
#elif defined bioFasham
      parameter(nt=9+CodAdd)
#elif defined bioMcGillic
      parameter(nt=6+CodAdd)
#elif defined bioDuse
       parameter(nt=9+CodAdd,lm=61)
#else
      parameter(nt=2)
#endif
      parameter(mprof=1000)
#ifdef coast
      parameter(mcseg=7,mclen=2000)
#endif
#ifdef ext_tide
      parameter(maxcomp=5)
#endif
#if defined posmxtid & ( !defined mixtide | !defined ext_tide )
      parameter (tdboxmx=100)
#endif
#ifdef extraction
      parameter(msubdom=2,ximt=53,xkm=16)
#endif
#ifdef peprf
      parameter (mhdr=20,mhflds=10,mhvar=4,mnbprf=10000)
#endif
#if defined nest2larger | defined nest2smaller
      parameter(xmdat=2835*km)
# if defined nest_ext2lrgr | defined nest_ext2smlr
      integer xmndat
      parameter(xmndat=200*200)
# endif
#endif
c
#ifndef rmdocinc
c-----------------------------------------------------------------------
c  End of user set parameters.
c-----------------------------------------------------------------------
c
#endif
      parameter(imtjmt=imt*jmt
#ifdef cyclic
     *    ,imu=imt
#else
     *    ,imu=imt-1
#endif
     *    ,imtp1=imt+1,imtm1=imt-1,imtm2=imt-2,imum1=imu-1,imum2=imu-2
     *    ,jmtp1=jmt+1,jmtm1=jmt-1,jmtm2=jmt-2
     *    ,jscan=jmtm2
     *    ,kmp1=km+1,kmp2=km+2,kmm1=km-1
     *    ,nslab=imt*((nt+2)*km+lbc),nwds=imt*jmt,nswich=lbc*imt
     *    ,ndices=2*lseg*jmt+4*misle
     *    ,imtkm=imt*km,ntmin2=nt+1/nt,nkflds=7+(ndices/nwds))
#ifdef extraction
      parameter(ximtkm=ximt*xkm)
#endif
#ifdef peprf
      parameter (mhpts=kmp1)
#endif
#if defined surfpress | defined pcg5
      integer isesize
      parameter (isesize=ijmx*lseg)
      integer nmax, nzmax,lwk
      parameter (nmax=imt*jmt,nzmax=nmax*32,lwk=nmax*40)
#endif
