c
c=======================================================================
c  Include file "pe_netcdf.h".
c=======================================================================
#ifndef rmdocinc
c
c  JUL_OFF   modified Julian day offset.
c  HISTORY   global history attribute (character).
c  RCODE     error code returned by NetCDF library (0 for no errors).
c  SINDX     index for a scalar (0: no dimension).
c  SPVAL     special values used as a fill or missing value.
c  TNAME     attributes for tracer variables (character array):
c            TNAME(1,N): NetCDF variable name of N-tracer.
c            TNAME(2,N): long_name variable attribute of N-tracer.
c            TNAME(3,N): units variable attribute of N-tracer.
c            TNAME(4,N): field variable attribute of N-tracer.
c  VARID     generic ID for arbitrary variables in NetCDF files.
c  XINDX     index for first dimension a vector.
c  YINDX     index for second dimension of a vector.
c  ZINDX     index for third dimension of a vector.
c
c  Input initialization/assimilation NetCDF IDs:
c
c  EMAXID    assimilation, maximum observation error.
c  EMINID    assimilation, minimum observation error.
c  NCINPID   NetCDF ID for initialization file.
c  NCASSID   NetCDF ID for assimilation file.
c  PBRYID    boundary, transport streamfunction.
c  PERRID    observation error, transport streamfunction.
c  PINIID    initialization, transport streamfunction.
c  POBSID    assimilation, transport streamfunction.
c  QBRYID    boundary, time rate of change of barotropic vorticity.
c  TASSID    assimilation, time.
c  TASSINDX  assimilation, counter for time dimension.
c  TASSMAX   assimilation, size of time dimension.
c  TBRYID    boundary, tracer type of variables.
c  TERRID    observation error, tracer type of variables.
c  TINIID    initialization, tracer type of variables.
c  T0INPID   initialization, time.
c  TINPID    boundary, time.
c  TINPINDX  boundary, counter for time dimension.
c  TINPMAX   boundary, size of time dimension.
c  TOBSID    assimilation, tracer type of variables.
c  VBRYID    boundary, internal mode velocity.
# ifdef surfpress
c  VBBYID    boundary, external velocity
c  VBINID    initialization, external velocity.
c  VBERID    observation error, external velocity.
c  VBOBID    assimilation, external velocity.
# endif
c  VERRID    observation error, internal mode velocity.
c  VINIID    initialization, internal mode velocity.
c  VOBSID    assimilation, internal mode velocity.
c
c  Input forcing fields NetCDF IDs:
c
c  NCFRCID   NetCDF ID for forcing file.
c  SHFID     surface heat flux.
c  SMFID     surface momentum flux.
c  SNFID     surface nutrient flux.
c  SWFID     surface water flux.
c  SHFTID    surface heat flux time.
c  SMFTID    surface momentum flux time.
c  SNFTID    surface nutrient flux time.
c  SWFTID    surface water flux time.
c  SWRID     shortwave radiation.
c  SWRTID    shortwave radiation time.
c  TSHFINDX  surface heat flux, counter for time dimension.
c  TSMFINDX  surface momentum flux, counter for time dimension.
c  TSNFINDX  surface biology flux, counter for time dimension.
c  TSWFINDX  surface water flux, counter for time dimension.
c  TSWRINDX  shortwave radiation, counter for time dimension.
# ifdef ext_tide
c
c  Input/Output Tidal NetCDF IDs:
c
c  NCTDID    Identifier for netCDF tidal data file.
c  NCTDST    Status flag for netCDF tidal data file.
c  STIDID    Tidal surface elevation identifier.
#  ifdef tide_zero
c  TTIDID    Residual tidal stress identifier.
#  endif
c  VTIDID    Tidal velocity identifier.
# endif
c
c  Output Lagrangian drifters NetCDF IDs:
c
c  TRKDENID  drifter density.
c  TRKDIAID  drifter diameter.
c  TRKIDID   drifter identifier.
c  TRKPOS    drifter position.
c  TRKTIMID  drifter time.
c  TRKTYPID  drifter type.
c  TRKVELID  drifter velocity.
c
c  Output energy/diagnostics NetCDF IDs:
c
c  ASSTID    average surface tracer.
c  ATWVID    average tracer within volume.
c  AVWVID    average velocity within volume.
c  BAVGID    average buoyancy work.
c  BUOYID    buoyancy work.
c  EKEAVGID  rate of change of average external mode kinetic energy.
c  IKEAVGID  rate of change of average internal mode kinetic energy.
c  KETOTID   total kinetic energy.
c  KETRMID   rate of change of average kinetic energy components.
c  MBTRMID   rate of change of zonal momentum term balances.
c  NCNRGID   NetCDF ID for energy/diagnostics output file.
c  SMFLXID   surface momentum flux.
c  STFLXID   surface tracer flux.
c  TBTRMID   rate of change of tracer term balances.
c  TCONVID   rate of change of tracer due to convection.
c  TMTID     meridional mass transport.
c  TNRGID    output time for energy.
c  TNRGINDX  counter for time dimension.
c  TTNID     northward transport components of tracer.
c  TVARID    rate of change of tracer variance.
c
c  PE output NetCDF IDs:
c
c  BGRDID    bacteria uptake rate of DON.
c  BGRNID    bacteria uptake rate of NH4.
c  DENAID    density anomaly.
c  EXPTID    particle export rate in McGillicuddy biological model.
c  FPFLID    fast-sinking particle flux in Fasham biological model.
c  LANDTID   land/sea mask at tracer points.
c  LANDVID   land/sea mask at velocity points.
c  MLDID     mixed-layer depth.
c  NCOUTID   NetCDF ID for PE output file.
# ifdef pressbias
c  NCPBID    NetCDF ID for Pressure Bias file  (I/O).
c  NCPBST    Status flag for Pressure Bias file  (I/O).
# endif
c  NCTRKID   NetCDF ID for drifters tracjetory output file.
c  NH4PID    NH4 production rate.
c  NO3PID    NO3 production rate.
c  PBARID    transport streamfunction.
c  QBARID    barotropic vorticity.
c  TBTHID    bathymetry at tracer points.
c  TOUTID    output time.
c  TOUTINDX  counter for output time dimension.
c  TRCSID    tracer type of variables.
c  TRMTVID   identifiers for tracer term balances
c  VCLIID    internal velocity vector.
c  VBARID    external velocity vector.
c  VGEOID    integrated geostrophic velocity velocity vector.
c  VTOTID    total velocity vector.
c  WVSTID    terrain-following vertical velocity at tracer points.
c  WVSVID    terrain-following vertical velocity at velocity points.
c  WVZTID    vertical velocity at tracer points.
c  WVZVID    vertical velocity at velocity points.
c  ZGRBID    zooplankton grazing rate of bacteria.
c  ZGROID    zooplankton grazing rate of PON. 
c  ZGRPID    zooplankton grazing rate of phytoplankton.
# if defined oias & defined fcsterr
c  PFERID    forecast error, transport streamfunction.
c  TFERID    forecast error, tracer type of variables.
c  VFERID    forecast error, internal mode velocity.
# endif
c
c=======================================================================
#endif
c
      common /ipe_netcfd/ asstid,atwvid,avwvid,bavgid,bgrdid,bgrnid,
     *       buoyid,denaid,ekeavgid,emaxid,eminid,exptid,fpflid,
     *       ikeavgid,ketotid,ketrmid,landtid,landvid,mbtrmid,mldid,
     *       ncassid,ncfrcid,ncinpid,ncnrgid,ncnrgst,ncoutid,ncoutst,
     *       nctrkid,nctrkst,nh4pid,no3pid,pbarid,pbryid,perrid,piniid,
     *       pobsid,qbarid,qbryid,rcode,tassid,tassindx,tassmax,tbryid,
     *       tbthid,shfid,shftid,smfid,snfid,smflxid,smftid,snftid,
     *       stflxid,swfid,swftid,swrid,swrtid,tbtrmid,tconvid,terrid,
     *       t0inpid,tinpid,tiniid,tinpindx,tinpmax,tmtid,tnrgid,
     *       tnrgindx,tobsid,toutid,toutindx,trcsid,trkdenid,trkdiaid,
     *       trkidid,trkposid,trktimid,trktypid,trkvelid,trmtvid,
     *       tsnfindx,tshfindx,tsmfindx,tswfindx,tswrindx,ttnid,tvarid,
     *       varid,vbarid,vbryid,vcliid,verrid,vgeoid,viniid,vobsid,
     *       vtotid,wvstid,wvsvid,wvztid,wvzvid,zgrbid,zgroid,zgrpid
#ifdef surfpress
     *       ,vbbyid,vbinid
# ifdef oias
     *       ,vberid,vbobid
# endif
#endif
#ifdef pressbias
     *       ,ncpbid,ncpbst
#endif
#if defined oias & defined fcsterr
     *       ,pferid,tferid,vferid
#endif
#if defined ext_tide
     *       ,stidid,vtidid,nctdid,nctdst
# ifdef tide_zero
     *       ,ttidid
# endif
#endif
      integer asstid,atwvid,avwvid,bavgid,bgrdid,bgrnid,buoyid,denaid,
     *        ekeavgid,emaxid,eminid,exptid,fpflid,ikeavgid,ketotid,
     *        ketrmid,landtid,landvid,mbtrmid,mldid,ncassid,ncfrcid,
     *        ncinpid,ncnrgid,ncnrgst,ncoutid,ncoutst,nctrkid,nctrkst,
     *        nh4pid,no3pid,pbarid,pbryid,perrid,piniid,pobsid,qbarid,
     *        qbryid,rcode,shfid,shftid,smfid,snfid,smflxid,smftid,
     *        snftid,stflxid,swfid,swftid,swrid,swrtid,tassid,tassindx,
     *        tassmax,tbryid,tbthid,tbtrmid,tconvid,t0inpid,tinpid,
     *        tinpindx,tinpmax,tmtid,tnrgid,tnrgindx,toutid,toutindx,
     *        trkdenid,trkdiaid,trkidid,trkposid,trktimid,trktypid,
     *        trkvelid,tsnfindx,tshfindx,tsmfindx,tswfindx,tswrindx,
     *        ttnid,tvarid,varid,vbarid,vbryid,vcliid,verrid,vgeoid,
     *        viniid,vobsid,vtotid,wvstid,wvsvid,wvztid,wvzvid,zgrbid,
     *        zgroid,zgrpid
#ifdef surfpress
     *       ,vbbyid,vbinid
# ifdef oias
     *       ,vberid,vbobid
# endif
#endif
#ifdef pressbias
     *       ,ncpbid,ncpbst
#endif
#if defined oias & defined fcsterr
     *       ,pferid,vferid
#endif
#if defined ext_tide
     *       ,stidid,vtidid,nctdid,nctdst
# ifdef tide_zero
     *       ,ttidid
# endif
#endif
      integer terrid(nt),tiniid(nt),tobsid(nt),trcsid(nt),trmtvid(nt)
#if defined oias & defined fcsterr
     *       ,tferid(nt)
#endif
c
      common /cpe_netcdf/ tname,history
      character*44  tname(4,nt)
      character*120 history
c
      integer sindx,xindx,yindx,zindx
      FLOAT
     *      jul_off,spval
      parameter (jul_off=2440000.0,spval=1.0e+35,sindx=0,xindx=1,
     *           yindx=2,zindx=3)
