       subroutine Pressure
c
c=======================================================================
c                                                                    ===
#if !defined freesurf
c  Rigid Lid Pressure Formulation                                    ===
#else
c  Free Surface  Pressure Formulation                                ===  
#endif
#ifdef solvercg
c Elliptic Solver : CG.                                              ===
#else
c Elliptic Solver : CG with Right preconditioner.                    ===
#endif
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fullwd.h>
#include <scalar.h>
#include <onedim.h>
#include <fields.h>
#include <workspb.h>
#include <bndata.h>
#include <moddat.h>
#include <filtdat.h>
#include <iounits.h>
#include <vertslabs.h>
#ifdef bndy_rlx
# include <bndyrlx.h>
#endif
#include<sinfo.h>
#include<convinfo.h>
c
c-----------------------------------------------------------------------
c  Define local and equivalence data.
c-----------------------------------------------------------------------
c
      integer i,j,luptd,luptdb
      FLOAT 
     *     dxx,dyy,fxa,fxb
#ifdef shapiro
      integer nn
#endif
      FLOAT
     *     ptdb(imt,jmt),a(imt,jmt,0:8),hvex(imt,jmt),vmetx(imt,jmt)
c
#ifndef solvercg
      integer ir(imt*jmt),ia(imt*jmt+1),ja(9*imt*jmt)
      FLOAT
     *     amt(9*imt*jmt),rp(imt*jmt),pspar(imt*jmt)
#else
      double precision wk(imt*jmt,4)
#endif
#ifdef freesurf
      FLOAT
     *      diagcof
#endif
#if defined localfilter
      FLOAT
     *     xtest(imt*jmt)
#endif
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c=======================================================================
c  Begin introductory section to prepare the iterations      ===========
c=======================================================================
c
c-----------------------------------------------------------------------
c  Initiate reading of relaxation solution of 2 timesteps back
c  for the purpose of computing an initial guess for the present pass
c  (input unit alternates on timesteps between 5 & 6)
c-----------------------------------------------------------------------
c
      luptdb=6-mod(itt,2)
      luptd =5+mod(itt,2)
      call ofind(kflds,nwds,(luptdb-1)*nwds+1)
c

c-----------------------------------------------------------------------
c  Complete reading of relaxation solution of 2 timesteps back and
c  initiate reading of relaxation solution of previous timestep
c  (input unit alternates on timesteps between 6 & 5)
c-----------------------------------------------------------------------
c
      call oget(kflds,nwds,(luptdb-1)*nwds+1,ptdb)
      call ofind(kflds,nwds,(luptd-1)*nwds+1)
c
c-----------------------------------------------------------------------
c  Save rate change of barotropic divergence in array ZTDB for output
c  purposes.
c-----------------------------------------------------------------------
c
      do 40 j=1,jmt
      do 40 i=1,imt
        ztdb(i,j)=ztd(i,j)
  40  continue
c
c-----------------------------------------------------------------------
c  Compute a first guess for the relaxation by extrapolating the two
c  previous solutions forward in time.
c-----------------------------------------------------------------------
c
c  1st, complete reading of previous timestep solution.
c
      call oget(kflds,nwds,(luptd-1)*nwds+1,ptd)
c
c  2nd, perform time extrapolation (accounting for mixing timestep).
c
      fxa=c1
      fxb=c2
      if(mixts.or.mxpas2) fxa=p5
      do 110 j=1,jmt
      do 110 i=1,imt
        ptd(i,j)=fxa*(fxb*ptd(i,j)-ptdb(i,j))
 110  continue
c-----------------------------------------------------------------------
c  Get Dirichlet boundary conditions at North, South, East, West 
c  boundaries or cyclic boundary conditions in the East-West direction.
c-----------------------------------------------------------------------
c
c  Update the time change of stream function at the southern and
c  northern boundaries.
c
      do 120 i=2,imtm1
        ptd(i,1)=po(i,1,south)-pb(i,1)
        ptd(i,jmt)=po(i,1,north)-pb(i,jmt)
 120  continue
#ifdef cyclic
c
c  Set Cyclic boundary conditions.
c
      do 130 j=1,jmt
        ptd(1  ,j)=ptd(imtm1,j)
        ptd(imt,j)=ptd(2    ,j)
 130  continue
#else
c
c  Update the time change of stream function at the western and
c  eastern boundaries.
c
      do 140 j=1,jmt
        ptd(1,j)=po(j,1,west)-pb(1,j)
        ptd(imt,j)=po(j,1,east)-pb(imt,j)
 140  continue
#endif
c
c
c-----------------------------------------------------------------------
c  Set up the metrics for construction matrix elements.
c-----------------------------------------------------------------------
c
      do 134 i=1,imt
        do 136 j=1,jmt
          vmetx(i,j)=cs(j)
136     continue
134   continue
      dxx=dxt(1)
      dyy=dyt(1)
c
c-------------------------------------------------------
c  Get the weighted depth : Rigid-Lid or Free surface 
c  computation.
c-------------------------------------------------------
c
      do 146 i=1,imt
        do  148 j=1,jmt
#ifndef freesurf
          hvex(i,j)=hdvc(i,j)
#else 
          hvex(i,j)=hdvcf(i,j)
#endif
148     continue
146   continue
#ifdef freesurf
      diagcof=c2/(alphav*thetasd*grav*c2dtsf*c2dtsf)
#endif
c
#ifdef coast
          call Press_solve(imt,jmt,lseg,dxx,dyy,
     *                     isq,ieq,isp,iep,a,ptd,hvex,ztd,vmetx,
#else
          call Press_solve(imt,jmt,dxx,dyy,a,ptd,hvex,ztd,vmetx,
#endif
#ifdef freesurf
     *                     diagcof,
#endif
#ifndef solvercg
     *                     ir,ia,ja,amt,rp,pspar
#else
     *                     wk,imt*jmt
#endif
#if defined localfilter
     *                     ,xtest
#endif
     *                     )
c
c  Report convergence information.
c
          
         if(mod(itt,ntsi).eq.0) write(stdout,900)
     *        resini,residu,restarget,mican

c
c-------------------------------------------------------------------
c  Update the surface pressure.
c-------------------------------------------------------------------
c
      if(.not.mxpas2) then
        do 620 j=1,jmt
        do 620 i=1,imt
          ptdb(i,j)=pb(i,j)+ptd(i,j)
          pb(i,j)=p(i,j)
          p(i,j)=ptdb(i,j)
 620    continue
      else
        do 630 j=1,jmt
        do 630 i=1,imt
          p(i,j)=pb(i,j)+ptd(i,j)
 630    continue
      endif

c
c-----------------------------------------------------------------------
c  Filter/smooth surface pressure field
c-----------------------------------------------------------------------
#ifdef shapiro
c
c  If requested, apply Shapiro filter:
c
c       ICNTP = counter (for frequency of application)
c       NFRQP = frequency with which filter is applied
c       NTIMP = number of times filter is applied per time step
c       NORDP = order of the filter
c
      icntp=icntp+1
      if(icntp.eq.nfrqp)then
        icntp=0
        if(nordp.gt.0)then
          do 640 nn=1,ntimp
            call shap_lev(p,imt,jmt,pgrid,nordp)
 640      continue
c
# ifndef cyclic 
#  ifdef coast
          p(1,1)=p5*p(1,2)+p5*p(2,1)
          p(imt,1)=p5*p(imt-1,1)+p5*p(imt,2)
          p(1,jmt)=p5*p(1,jmt-1)+p5*p(2,jmt)
          p(imt,jmt)=p5*p(imt,jmt-1)+p5*p(imt-1,jmt)
#  endif
# else
c
c  Set Cyclic boundary conditions.
c
      do 645 j=1,jmt
        p(1  ,j)=p(imtm1,j)
        p(imt,j)=p(2    ,j)
 645  continue

# endif
          do 650 j=1,jmt
          do 650 i=1,imt
            ptdb(i,j)=p(i,j)
 650      continue
        endif
      endif
#endif
c
c-----------------------------------------------------------------------
c  Save PTD to compute 1st guess for  next timestep
c  (..note.. on 1st pass of Euler backward timestep, bypass this
c            save, since it will be done on the 2nd pass)
c  (..note.. on a mixing timestep, alter ptd to be consistent with
c            normal, leap-frog stepping)
c-----------------------------------------------------------------------
c
      c2dtps = c2dtsf
      if((mix.eq.1).and.eb) return
      if((mxp.ne.0).or.(mix.ne.0)) then
        c2dtps = c2*c2dtps
        do 660 j=1,jmt
        do 660 i=1,imt
          ptd(i,j)=c2*ptd(i,j)
 660    continue
      endif
      call oput(kflds,nwds,(luptdb-1)*nwds+1,ptd)
c

 900  format (
#ifndef solvercg
     *        ' PCG res.:',
#else
     *        ' CG res.:',
#endif
     *        ' Initial ',1pe10.3,
     *        ' Final ',1pe10.3,
     *        ' Target ',1pe10.3,
     *        ' MICAN ', i4  )

      return
      end
