      subroutine reset_advect (iunit)
C
C=======================================================================
C                                                                    ===
C  This routine updates barotropic advection accounting for volume   ===
c  box changes from time TAU to time TAU+1. The internal velocities  ===
c  is  reset to vertically averaged zero mean for time TAU+1.        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <vertslabs.h>
#include <onedim.h>
#include <voldat.h>
#include <workspa.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer nstr,nend
      parameter (nstr=nt*imtkm, nend=nstr+2*imtkm-1)
c
      integer i,ip,iunit,j,k
      FLOAT
     *        umz,vmz,fx
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c  Roll over local thicknesses
c
      do 130 j=1,jmt-1
        call oget(iunit,nslab,(j-1)*nslab+1,ta)
        call get_thick (j,vgrid,dzvqz(1,1,0),dzzvqz(1,1,0),kmp1)
        do 106 i=1,imt
           ip=(j-1)*imt+i
           umz=c0
           vmz=c0        
           fx=c0
           do 100 k=1,km
              umz=umz+dzvqz(i,k,0)*xu(ip,k)
              vmz=vmz+dzvqz(i,k,0)*xv(ip,k)
              fx=fx+dzvqz(i,k,0)
 100       continue
           umz=umz/fx
           vmz=vmz/fx
           do 105 k=1,km
              xu(ip,k)=xu(ip,k)-umz
              xv(ip,k)=xv(ip,k)-vmz
              ua(i,k)=xu(ip,k)
              va(i,k)=xv(ip,k)
 105       continue
 106    continue
         call oput(iunit,nslab,(j-1)*nslab+1,ta)
 130  continue
      return
      end


