      subroutine scalvcln (vin,vout)
c
c=======================================================================
c                                                                    ===
c  This routine multiplies the supplied baroclinic velocity          ===
c  component by the local box thickness.  Used in nesting to         ===
c  ensure baroclinicity of passed velocities.                        ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     VIN   Baroclinic velocity component to scale.   (real array)   ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /VERTICAL/                                                        ===
c                                                                    ===
c     DZV   Thicknesses of UV vertical boxes.       (real array; cm) ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     VOUT   Scaled baroclinic velocity component.    (real array)   ===
c                                                                    ===
c  Calls:  SETVERT                                                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <vertical.h>
c
c-----------------------------------------------------------------------
c  Define local and equivalence data.
c-----------------------------------------------------------------------
c
      integer i,j,k
      FLOAT
     *      vin(imt,jmt,km),vout(imt,jmt,km)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 10 j = 1, jmt
         do 10 k = 1, km
         do 10 i = 1, imt
            vout(i,j,k) = vin(i,j,k)*dzv(i,j,k)
  10  continue
c
      return
      end
